<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePersonTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('person', function (Blueprint $table) {
            $table->integer('no');
            $table->string('id',10);
            $table->string('name',10);
            $table->integer('sex');
            $table->integer('type');
            $table->text('toke1n')->nullable();
            $table->mediumText('photo')->nullable();
            $table->string('start',13)->nullable();
            $table->string('end',13)->nullable();
            $table->string('created',13);
            $table->string('updated',13);
            $table->string('deleted',13)->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('person');
    }
}
