@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>


    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="/js/bootstrap-toggle.min.js"></script>


@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '13'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row align-items-center" style="height: 70px;">
                        {{--搜尋設備類型--}}
                        <div class="col-8">
                            <form action="{{ route("select_type") }}">
                                <div class="input-group ">
                                    <Select name=set required data-validation-required-message="選擇搜尋的欄位" class="custom-select " id="set">
                                        <Option value="">選擇搜尋的欄位</Option>
                                        <Option value="Name">類型名稱</Option>
                                        <Option value="Vendor">供應商</Option>
                                    </Select>
                                    <input  type="text" class="form-control " aria-label="Default" aria-describedby="inputGroup-sizing-default" name="value" placeholder="輸入搜尋的值">
                                    <button type="submit" class="btn btn-primary ">搜尋設備類型</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                        {{--新增設備類型--}}
                        <div class="col-2">
                            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#insertModalCenter">
                                新增設備類型
                            </button>
                        </div>
                    </div>

                    {{--呈現設備類型--}}
                    <table border="3"  class="table table-hover">
                        <thead  class="thead-dark" style="text-align:center;">
                        <tr>
                            <th></th>
                            <th>類型名稱</th>
                            <th>供應商</th>
                            <th>供應商聯繫人</th>
                            <th>供應商聯繫方式</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($types as $type)
                            <tr>
                                <th style="text-align:center;">{{ $type["id"] }}</th>
                                <th style="text-align:center;">{{ $type["name"] }}</th>
                                <th style="text-align:center;">{{$type["vendor"]}}</th>
                                <th style="text-align:center;">{{$type["vendorContactPerson"]}}</th>
                                <th>{{$type["vendorContactWay"]}}</th>
                                <th style="text-align:center;">
                                    <button style="width: 70px;" class="btn btn-success"  data-toggle="modal" data-target="#updateModalCenter" onclick="data({{ $type["id"] }},'{{ $type["name"] }}','{{$type["vendor"]}}','{{$type["vendorContactPerson"]}}','{{$type["vendorContactWay"]}}')"><strong>修改</strong></button>&nbsp&nbsp&nbsp
                                    <button style="width: 70px;" class="btn btn-danger" onclick="javascript:location.href='{{ Route("delete_type",["id"=>$type["id"]]) }}'"><strong>刪除</strong></button>
                                </th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{--新增設備類型彈跳視窗--}}
    <div class="modal fade" id="insertModalCenter" tabindex="-1" role="dialog" aria-labelledby="insertModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增設備類型</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("insert_type") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">類型名稱</span>
                                </div>
                                <input  type="text" class="form-control " aria-label="Default" aria-describedby="inputGroup-sizing-default" name="name" placeholder="Name" maxlength="15">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor" placeholder="Vendor">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商聯絡人</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor_contact_person" placeholder="VendorContactPerson">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商聯繫方式</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor_contact_way" placeholder="VendorContactWay">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                        <button type="submit" class="btn btn-primary" >新增</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--修改設備類型彈跳視窗--}}
    <div class="modal fade" id="updateModalCenter" tabindex="-1" role="dialog" aria-labelledby="updateModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改設備類型</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("update_type") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">類型ID</span>
                                </div>
                                <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="id" placeholder="ID" id="update_id">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">類型名稱</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="name" placeholder="Name" id="update_name">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor" placeholder="Vendor" id="update_vendor">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商聯絡人</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor_contact_person" placeholder="VendorContactPerson" id="update_vendor_contact_person">
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroup-sizing-default">供應商聯繫方式</span>
                                </div>
                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="vendor_contact_way" placeholder="VendorContactWay" id="update_vendor_contact_way">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                        <button type="submit" class="btn btn-primary" >修改</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        //修改資料帶入
        function data($id,$name,$vendor,$vendorContactPerson,$vendorContactWay) {
            document.getElementById("update_id").value=$id;
            document.getElementById("update_name").value=$name;
            document.getElementById("update_vendor").value=$vendor;
            document.getElementById("update_vendor_contact_person").value=$vendorContactPerson;
            document.getElementById("update_vendor_contact_way").value=$vendorContactWay;
        }
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

@endsection
