@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
<link rel="stylesheet" href="/css/selectize.min.css" />
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
<script src="/js/selectize.min.js"></script>


{{--    引入bootstrap-table css樣式與js--}}
{{--    <link href="/css/bootstrap-table.css" rel="stylesheet">--}}
<link rel="stylesheet" href="https://unpkg.com/bootstrap-table@1.18.3/dist/bootstrap-table.min.css">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
<script src="https://unpkg.com/bootstrap-table@1.18.3/dist/bootstrap-table.min.js"></script>
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 70vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '7'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                        {{ csrf_field() }}
                        <div class="row" style="height: 7vh;align-items: center">
                            {{--datetime 起始時間選擇--}}
                            <div class="col-3">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">起始時間</div>
                                    </div>
                                    <input id="leave_start" style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            {{--datetime 結束時間選擇--}}
                            <div class="col-3">
                                <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">結束時間</div>
                                    </div>
                                    <input id="leave_end" style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                    <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave()">查詢</button>
                                @if($level=="3"or$level=="4")
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="export_leave()">匯出</button>
                                @endif
                            </div>
                            <div class="col-3"></div>
                    </div>
                    <div class="row" style="height: 7vh;align-items: center">
                        <div class="col-3"></div>
                        <div class="col-3">
                            @if($level!="1")
                                <select style="text-align: center"  id="person_choose" placeholder="請選擇姓名" name="person">
                                    <option value=""></option>
                                    @foreach($persons as $person)
                                        @if(isset($person_id))
                                            @if($person["id"]==old('person'))
                                                <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                            @else
                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                            @endif
                                        @else
                                            <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            @endif
                        </div>
                        <div class="col-3">
                            @if($level!="1")
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave_personal()">查詢個人</button>
                            @endif
                        </div>
                        <div class="col-3 float-right">
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertEmplyoeeLeave">新增假單</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="javascript:location.href='{{ Route("leave_all") }}'">查看所有請假紀錄</button>
                        </div>
                    </div>
                    {{--表格呈現-請假列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 70vh"></table>
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        <div class="col-10">
                            <p class="h6">特休天數：14~15天：一季至少休3~4天  &emsp;16~20天：一季至少休5天</p>
                            <p class="h6">&emsp;&emsp;&emsp;&emsp;&emsp;21~25天：一季至少休6天  &nbsp&emsp;&emsp;26~30天：一季至少休7天</p>
                        </div>
                        <div class="col-2">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 新增假單彈出視窗 --}}
    <div class="modal fade" id="InsertEmplyoeeLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增假單</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("post_employeeleave") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <label for="selectPerson" style="text-align: right" class="col-3 col-form-label">請假人員姓名</label>
                                <div class="col-9">
                                    @if($level=="1")
                                        <input readonly id='person' name="person" style="text-align: center"  type="hidden" class="form-control" value="{{$person_id}}" >
                                        <input readonly style="text-align: center"  type="text" class="form-control" value="{{$person_name}}" >
                                    @else
                                        <select class="custom-select form-control" id="selectPerson" name="person">
                                            <option disabled selected>請選擇姓名</option>
                                            @foreach($persons as $person)
                                                @if($person["id"]==$person_id)
                                                    <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                                @else
                                                    <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="department" >部門</label>
                                <div class="col-9">
                                    @if($level=="1")
                                        <input readonly id='department' name="department" style="text-align: center"  type="hidden" class="form-control" value="{{$department_no}}" >
                                        <input readonly  style="text-align: center"  type="text" class="form-control" value="{{$department_name}}" >
                                    @else
                                        <select class="custom-select form-control" id="inputDepartment" name="department" required>
                                            <option selected disabled >請選擇部門</option>
                                            @foreach($departments as $department)
                                                @if($department["no"]==$department_no)
                                                    <Option value="{{ $department["no"] }}" selected>{{ $department["department"] }}</Option>
                                                @else
                                                    <Option value="{{ $department["no"] }}">{{ $department["department"] }}</Option>
                                                @endif
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="selectCategory" style="text-align: right" class="col-3 col-form-label">假別</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="selectCategory" name="category" required="required" onchange="Category()">
{{--                                  <option disabled selected>請選擇假別</option>--}}
                                        <option value="特休" selected>特休</option>
                                        <option value="公假">公假</option>
                                        <option value="事假">事假</option>
                                        <option value="病假">病假</option>
                                        <option value="公傷病假">公傷病假</option>
                                        <option value="婚假">婚假</option>
                                        <option value="產假">產假</option>
                                        <option value="陪產假">陪產假</option>
                                        <option value="產檢假">產檢假</option>
                                        <option value="喪假">喪假</option>
                                        <option value="生理假">生理假</option>
                                        <option value="補假">補假</option>
                                        <option value="防疫照顧假">防疫照顧假</option>
                                        <option value="家庭照顧假">家庭照顧假</option>
                                        <option value="防疫隔離假">防疫隔離假</option>
                                        <option value="疫苗接種假">疫苗接種假</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="reason" >原因</label>
                                <div class="col-9">
                                    <input id='reason' name="reason" style="text-align: center"  type="text" class="form-control" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="start_time" style="text-align: right" class="col-3 col-form-label">請假時間</label>
                                <div class="col-9">
                                    <div style="background: white"  class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                        <input id='start_time' style="text-align: center" name="start_time" type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker3" onblur="date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <label class="input-group-text">~</label>
                                    </div>
                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                        <input id='end_time'  style="text-align: center" name="end_time"  type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker4" onblur="date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="leave_day" >請假天數</label>
                                <div class="col-3">
                                    <input id='leave_day' name="leave_day" style="text-align: center"  type="number" class="form-control" onkeyup="value=value.replace(/[^\d]/g,'')" maxlength="2" required>
                                </div>
                                <label style="text-align: right;" class="col-2 col-form-label" for="leave_time" >請假時長</label>
                                <div class="col-4">
                                    <input id='leave_time' name="leave_time" style="text-align: center"  type="number" class="form-control" step="0.5" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="substitute" >代理人</label>
                                <div class="col-3">
                                    <input id='substitute' name="substitute" style="text-align: center"  type="text" class="form-control">
                                </div>
                                <div class="col-6" style="text-align: left">
                                    @if(isset($remain_annual_leave_day))
                                        <h5 style="text-align:center">剩餘特休：{{$remain_annual_leave_day}} 日  {{$remain_annual_leave_hour}}小時</h5>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row" style="font-size: 14px">
                                <div class="col-12">
                                    <a>
                                        請假注意事項：
                                    </a><br>
                                    <a>
                                        一、員工因故必須請假者，應事先填寫請假單或口頭敘明理由經核定後方可離開工作崗位或不出勤。
                                    </a><br>
                                    <a>
                                        二、如遇急病或臨時重大事故，得於<a style="color: #e3342f;font-size: 16px"> 1 日內</a>委託同事、家屬、親友或以電話、傳真、E─mail、限時函件報告單位主管，代辦請假手續。
                                    </a><br>
                                    <a>
                                        三、如需補述理由或提供證明，當事人應於<a style="color: #e3342f;font-size: 16px"> 2 日內</a>提送，其工作單位按權責核定之。
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary" id="insert_btn">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 修改假單彈出視窗 --}}
    <div class="modal fade" id="ModifyLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改請假資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("update_employeeleave") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <input id='no' name="no" style="text-align: center"  type="hidden">
                                <label for="selectPerson" style="text-align: right" class="col-3 col-form-label">請假人員姓名</label>
                                <div class="col-9">
                                    <input readonly id='midify_person' name="person" style="text-align: center"  type="hidden" class="form-control" >
                                    <input readonly id='modify_personname'  style="text-align: center"  type="text" class="form-control" >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="department" >部門</label>
                                <div class="col-9">
                                    <input readonly id='modify_department' name="department" style="text-align: center"  type="hidden" class="form-control">
                                    <input readonly id='modify_department_name' style="text-align: center"  type="text" class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="selectCategory" style="text-align: right" class="col-3 col-form-label">假別</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="modify_selectCategory" name="category" required>
                                        <option value="特休">特休</option>
                                        <option value="公假">公假</option>
                                        <option value="事假">事假</option>
                                        <option value="病假">病假</option>
                                        <option value="公傷病假">公傷病假</option>
                                        <option value="婚假">婚假</option>
                                        <option value="產假">產假</option>
                                        <option value="陪產假">陪產假</option>
                                        <option value="產檢假">產檢假</option>
                                        <option value="喪假">喪假</option>
                                        <option value="生理假">生理假</option>
                                        <option value="補假">補假</option>
                                        <option value="防疫照顧假">防疫照顧假</option>
                                        <option value="家庭照顧假">家庭照顧假</option>
                                        <option value="防疫隔離假">防疫隔離假</option>
                                        <option value="疫苗接種假">疫苗接種假</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="reason" >原因</label>
                                <div class="col-9">
                                    <input id='modify_reason' name="reason" style="text-align: center"  type="text" class="form-control" >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="start_time" style="text-align: right" class="col-3 col-form-label"> 請假時間</label>
                                <div class="col-9">
                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker5" data-target-input="nearest">
                                        <input id='modify_start_time' style="text-align: center" name="start_time" type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker5" onblur="update_date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker5" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <label class="input-group-text">~</label>
                                    </div>
                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker6" data-target-input="nearest">
                                        <input id='modify_end_time' style="text-align: center" name="end_time" type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker6" onblur="update_date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker6" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="leave_day" >請假天數</label>
                                <div class="col-3">
                                    <input id='modify_leave_day' name="leave_day" style="text-align: center"  type="number" class="form-control" onkeyup="value=value.replace(/[^\d]/g,'')" maxlength="2">
                                </div>
                                <label style="text-align: right;" class="col-2 col-form-label" for="leave_time" >請假時長</label>
                                <div class="col-4">
                                    <input id='modify_leave_time' name="leave_time" style="text-align: center"  type="number" class="form-control" step="0.5">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="substitute" >代理人</label>
                                <div class="col-3">
                                    <input id='modify_substitute' name="substitute" style="text-align: center"  type="text" class="form-control">
                                </div>
                            </div>
                            @if($level=="3" or $level=="4")
                                <div class="form-group row">
                                    <label style="text-align: right;" class="col-3 col-form-label" for="selectGroup">上傳證明檔案</label>
                                    <div class="col-6">
                                        <input type="file" id="upload_file" name="upload_file" >
                                    </div>
                                </div>
                            @endif
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary" id="update_btn">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        //新增假單日期計算
        function date()
        {
            var start = document.getElementById("start_time");
            var end = document.getElementById("end_time");
            if(start.value!=null && end.value!=null)
            {
                var day = document.getElementById("leave_day");
                var hour = document.getElementById("leave_time");
                var d1 = new Date(start.value);
                var d1_week=d1.getDay();
                var d2 = new Date(end.value);
                var d2_week=d2.getDay();
                var time=d2-d1;
                var time_hour=time/1000/60/60;
                var time_day=time/1000/60/60/24;
                var day_first=time/1000/60/60/24;
                if(time_day<=7)
                {
                    if(d1_week>d2_week)
                    {
                        time_day=time_day-2;
                        time_hour=time_hour-48;
                    }
                }
                else {
                    //先去掉頭尾兩週
                    time_day -= ((7 - d1_week) + (d2_week + 1));
                    //去掉中間的每週兩天
                    var weekcount= time_day / 7+1;
                    time_day = time_day / 7 * 5;
                    //加回頭尾兩週的工作天
                    if (d1_week == 0) time_day += 5;
                    if (d1_week > 0 && d1_week < 6) time_day += (6 - d1_week);
                    if (d2_week == 6) time_day += 5;
                    if (d2_week < 6) time_day += d2_week;
                    time_hour=time_hour-(parseInt(day_first)-parseInt(time_day))*24;
                }

                for(i=1;i<time_day;i++){
                    time_hour=time_hour-15;
                }
                if(time_hour>8)
                {
                    time_day++;
                    if(time_hour%9!=0)
                    {
                        time_day--;
                        if(d1.getHours()<=12 && d2.getHours()>=13)
                            time_hour--;
                    }
                }
                else
                {
                    if(d1.getHours()<=12 && d2.getHours()>=13)
                        time_hour--;
                }
                day.value=parseInt(time_day);
                hour.value=time_hour-(parseInt(time_day));
                if(time_hour<0)
                {
                    alert("時間有錯，結束時間要大於開始時間");
                    document.getElementById("insert_btn").disabled=true;
                }
                else
                    document.getElementById("insert_btn").disabled=false;
            }
        }
        //修改架單日期計算
        function update_date()
        {
            var start = document.getElementById("modify_start_time");
            var end = document.getElementById("modify_end_time");
            if(start.value!=null && end.value!=null)
            {
                var day = document.getElementById("modify_leave_day");
                var hour = document.getElementById("modify_leave_time");
                var d1 = new Date(start.value);
                var d1_week=d1.getDay();
                var d2 = new Date(end.value);
                var d2_week=d2.getDay();
                var time=d2-d1;
                var time_hour=time/1000/60/60;
                var time_day=time/1000/60/60/24;
                var day_first=time/1000/60/60/24;
                if(time_day<=7)
                {
                    if(d1_week>d2_week)
                    {
                        time_day=time_day-2;
                        time_hour=time_hour-48;
                    }
                }
                else {
                    //先去掉頭尾兩週
                    time_day -= ((7 - d1_week) + (d2_week + 1));
                    //去掉中間的每週兩天
                    var weekcount= time_day / 7+1;
                    time_day = time_day / 7 * 5;
                    //加回頭尾兩週的工作天
                    if (d1_week == 0) time_day += 5;
                    if (d1_week > 0 && d1_week < 6) time_day += (6 - d1_week);
                    if (d2_week == 6) time_day += 5;
                    if (d2_week < 6) time_day += d2_week;
                    time_hour=time_hour-(parseInt(day_first)-parseInt(time_day))*24;
                }

                for(i=1;i<time_day;i++){
                    time_hour=time_hour-15;
                }
                if(time_hour>8)
                {
                    time_day++;
                    if(time_hour%9!=0)
                    {
                        time_day--;
                        if(d1.getHours()<=12 && d2.getHours()>=13)
                            time_hour--;
                    }
                }
                else
                {
                    if(d1.getHours()<=12 && d2.getHours()>=13)
                        time_hour--;
                }
                day.value=parseInt(time_day);
                hour.value=time_hour-(parseInt(time_day));
                if(time_hour<0)
                {
                    alert("時間有錯，結束時間要大於開始時間");
                    document.getElementById("update_btn").disabled=true;
                }
                else
                    document.getElementById("update_btn").disabled=false;
            }
        }
        function Category()
        {
            var category = document.getElementById("selectCategory");
            if(category.value=="生理假")
            {
                alert("每月可請生理假1天");
            }
        }
    </script>
    <script>
        {{--修改假單資料--}}
        function leave_modify(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("no").value=jdata[jdata_index].no;
            document.getElementById("midify_person").value=jdata[jdata_index].id;
            document.getElementById("modify_personname").value=jdata[jdata_index].name;
            document.getElementById("modify_department").value=jdata[jdata_index].depart_leave_unit_department;
            document.getElementById("modify_selectCategory").value=jdata[jdata_index].category;
            document.getElementById("modify_reason").value=jdata[jdata_index].reason;
            document.getElementById("modify_start_time").value=jdata[jdata_index].start;
            document.getElementById("modify_end_time").value=jdata[jdata_index].end;
            document.getElementById("modify_leave_day").value=jdata[jdata_index].leave_day;
            document.getElementById("modify_leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("modify_substitute").value=jdata[jdata_index].substitute;
            document.getElementById("modify_department_name").value=jdata[jdata_index].department_name;
        }
        {{--匯出假單--}}
        function leave_word(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var leave_no=jdata[jdata_index].no;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_leave") }}");
            var id = document.createElement("input");
            id.setAttribute("type", "hidden");
            id.setAttribute("name", "leave_id");
            id.setAttribute("value",leave_no);
            form.appendChild(id);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        {{--搜尋假單--}}
        function select_leave() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("search_leave") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        {{--搜尋個人假單--}}
        function select_leave_personal() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var person=document.getElementById("person_choose").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("search_leave_personal") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var select_person = document.createElement("input");
            select_person.setAttribute("type", "hidden");
            select_person.setAttribute("name", "person");
            select_person.setAttribute("value",person);
            form.appendChild(select_person);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        {{--匯出區間請假資料--}}
        function export_leave() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_all_leave") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <script>
        {{--    取得已選取目標--}}
        function getIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        {{--    刪除假單--}}
        function post_delete_leave(obj) {
            let idselections=getIdSelections();
            if(idselections!="")
            {
                if(confirm("是否刪除"+idselections)){
                    var form = document.createElement("form");
                    form.setAttribute("method","post");
                    form.setAttribute("action","{{ Route("delete_employeeleave") }}");
                    var idselectionsField = document.createElement("input");
                    idselectionsField.setAttribute("type", "hidden");
                    idselectionsField.setAttribute("name", "selectedId");
                    idselectionsField.setAttribute("value",idselections);
                    form.appendChild(idselectionsField);
                    var csrfField=document.createElement("input");
                    csrfField.setAttribute("type", "hidden");
                    csrfField.setAttribute("name", "_token");
                    csrfField.setAttribute("value", "{{ csrf_token() }}");
                    form.appendChild(csrfField);
                    document.body.appendChild(form);    // Not entirely sure if this is necessary
                    form.submit();
                }
            }
            else
            {
                alert("請勾選要刪除的資料");
            }

        }
    </script>
    {{--下拉式選單-藉由輸入快速選擇(selectize)--}}
    <script>
        $(document).ready(function () {
            $('#person_choose').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--表格設定(boostrap-tabel)--}}
    <script>
        // 載入資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷毀表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'state', checkbox: true},
            {field: 'name',title: '人員名稱', sortable: true,footerFormatter:"總計"},
            {field: 'start', title: '請假開始時間', sortable: true,
                footerFormatter:function (rows){
                    return "共"+rows.length+"筆";
                }},
            {field: 'end', title: '請假結束時間', sortable: true,
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].leave_time)
                        sum += counts;
                    }
                    return "共"+sum+"小時";
                }},
            {field: 'modify', title: '修改', sortable: false},
            {field: 'delete', title: '刪除', sortable: false},
            {field: 'status', title: '狀態', sortable: true},
            {field: 'export', title: '', sortable: false},
        ];
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: {{$check}},
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            multipleSelectRow: true,
            sortName:'start', // 預設排序
            sortOrder:'desc',
        });
    </script>
    {{--日期選擇設定--}}
    <!-- 起始時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- 結束時間(datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
@endsection
