@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
<link rel="stylesheet" href="/css/selectize.min.css" />
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
<script src="/js/selectize.min.js"></script>


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '22'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                        {{ csrf_field() }}
                        <div class="row" style="height: 10vh;align-items: center">
                            {{--datetime 起始時間選擇--}}
                            <div class="col-3">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">起始時間</div>
                                    </div>
                                    <input id="leave_start" style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            {{--datetime 結束時間選擇--}}
                            <div class="col-3">
                                <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">結束時間</div>
                                    </div>
                                    <input id="leave_end" style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                    <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <select style="text-align: center"  id="selectPerson" placeholder="請選擇姓名" name="person">
                                    <option value=""></option>
                                    @foreach($persons as $person)
                                        @if(isset($person_id))
                                            @if($person["id"]==$person_id)
                                                <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                            @else
                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                            @endif
                                        @else
                                            <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                        @endif

                                    @endforeach
                                </select>
                            </div>
                            <div class="col-3">
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave()">查詢</button>
                                @if($level=="3"or$level=="4")
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="export_leave()">匯出</button>
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="export_leave_all()">匯出所有人員</button>
                                @endif
                            </div>
                    </div>
                    {{--表格呈現-統計請假時數--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                    {{--底端部分--}}
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        {{--datetime 起始時間選擇--}}
                        <div class="col-3">
                            <button id="button1" class="btn btn-secondary">防疫假別</button>
                        </div>
                        <div class="col-3">
                        </div>
                        <div class="col-3">
                        </div>
                        <div class="col-3">
                            @if($level=="3"or$level=="4")
                                <form class="row" id="form_attendance_download" method="POST" action="{{ Route("export_annual_statistics") }}">
                                    {{ csrf_field() }}
                                    <div class="input-group date" id="datetimepicker3" data-target-input="nearest" >
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">年份</div>
                                        </div>
                                        <input id='year' style="text-align: center" name="year" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                        <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <div class="input-group-append">
                                            <button class="btn btn-dark" type="submit">匯出</button>
                                        </div>
                                    </div>
                                </form>
                            @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--方法區--}}
    {{--下拉式選單-藉由輸入快速選擇(selectize)--}}
    <script>
        $(document).ready(function () {
            $('#selectPerson').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
        <script>
            //切換假別(防疫假/一般假)
            var $table = $('#tableL01')
            var $button1 = $('#button1')
            $(function () {
                $button1.click(function () {
                    var btn=document.getElementById("button1").innerHTML;
                    if(btn=="防疫假別")
                    {
                        $table.bootstrapTable('hideColumn', '特休')
                        $table.bootstrapTable('hideColumn', '公假')
                        $table.bootstrapTable('hideColumn', '事假')
                        $table.bootstrapTable('hideColumn', '病假')
                        $table.bootstrapTable('hideColumn', '公傷病假')
                        $table.bootstrapTable('hideColumn', '婚假')
                        $table.bootstrapTable('hideColumn', '產假')
                        $table.bootstrapTable('hideColumn', '陪產假')
                        $table.bootstrapTable('hideColumn', '喪假')
                        $table.bootstrapTable('hideColumn', '生理假')
                        $table.bootstrapTable('hideColumn', '補假')

                        $table.bootstrapTable('showColumn', '防疫照顧假')
                        $table.bootstrapTable('showColumn', '家庭照顧假')
                        $table.bootstrapTable('showColumn', '防疫隔離假')
                        $table.bootstrapTable('showColumn', '疫苗接種假')
                        document.getElementById("button1").innerHTML="一般假別";
                    }
                    else
                    {
                        $table.bootstrapTable('showColumn', '特休')
                        $table.bootstrapTable('showColumn', '公假')
                        $table.bootstrapTable('showColumn', '事假')
                        $table.bootstrapTable('showColumn', '病假')
                        $table.bootstrapTable('showColumn', '公傷病假')
                        $table.bootstrapTable('showColumn', '婚假')
                        $table.bootstrapTable('showColumn', '產假')
                        $table.bootstrapTable('showColumn', '陪產假')
                        $table.bootstrapTable('showColumn', '喪假')
                        $table.bootstrapTable('showColumn', '生理假')
                        $table.bootstrapTable('showColumn', '補假')

                        $table.bootstrapTable('hideColumn', '防疫照顧假')
                        $table.bootstrapTable('hideColumn', '家庭照顧假')
                        $table.bootstrapTable('hideColumn', '防疫隔離假')
                        $table.bootstrapTable('hideColumn', '疫苗接種假')
                        document.getElementById("button1").innerHTML="防疫假別";
                    }

                })
            })
        </script>
        <script>
            //查詢個人請假
            function select_leave() {
                var start=document.getElementById("leave_start").value;
                var end=document.getElementById("leave_end").value;
                var person=document.getElementById("selectPerson").value;
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("search_statistics") }}");
                var start_time = document.createElement("input");
                start_time.setAttribute("type", "hidden");
                start_time.setAttribute("name", "start");
                start_time.setAttribute("value",start);
                form.appendChild(start_time);
                var end_time = document.createElement("input");
                end_time.setAttribute("type", "hidden");
                end_time.setAttribute("name", "end");
                end_time.setAttribute("value",end);
                form.appendChild(end_time);
                var select_person = document.createElement("input");
                select_person.setAttribute("type", "hidden");
                select_person.setAttribute("name", "person");
                select_person.setAttribute("value",person);
                form.appendChild(select_person);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        </script>
        <script>
            //個人匯出
            function export_leave() {
                var start=document.getElementById("leave_start").value;
                var end=document.getElementById("leave_end").value;
                var person=document.getElementById("selectPerson").value;
                if(person=="")
                {
                    alert("此為個人匯出，請選擇人員");
                }
                else
                {
                    var form = document.createElement("form");
                    form.setAttribute("method","post");
                    form.setAttribute("action","{{ Route("export_statistics") }}");
                    var start_time = document.createElement("input");
                    start_time.setAttribute("type", "hidden");
                    start_time.setAttribute("name", "start");
                    start_time.setAttribute("value",start);
                    form.appendChild(start_time);
                    var end_time = document.createElement("input");
                    end_time.setAttribute("type", "hidden");
                    end_time.setAttribute("name", "end");
                    end_time.setAttribute("value",end);
                    form.appendChild(end_time);
                    var select_person = document.createElement("input");
                    select_person.setAttribute("type", "hidden");
                    select_person.setAttribute("name", "person");
                    select_person.setAttribute("value",person);
                    form.appendChild(select_person);
                    var csrfField=document.createElement("input");
                    csrfField.setAttribute("type", "hidden");
                    csrfField.setAttribute("name", "_token");
                    csrfField.setAttribute("value", "{{ csrf_token() }}");
                    form.appendChild(csrfField);
                    document.body.appendChild(form);    // Not entirely sure if this is necessary
                    form.submit();
                }
            }
        </script>
        <script>
            //全部人匯出
            function export_leave_all() {
                var start=document.getElementById("leave_start").value;
                var end=document.getElementById("leave_end").value;
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("export_all_statistics") }}");
                var start_time = document.createElement("input");
                start_time.setAttribute("type", "hidden");
                start_time.setAttribute("name", "start");
                start_time.setAttribute("value",start);
                form.appendChild(start_time);
                var end_time = document.createElement("input");
                end_time.setAttribute("type", "hidden");
                end_time.setAttribute("name", "end");
                end_time.setAttribute("value",end);
                form.appendChild(end_time);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        </script>
        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif

        {{--表格設定(boostrap-tabel)--}}
    <script>
        // 載入資料
        @php
            if (isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).';';
            }else{
                echo "var jdata=[];";
            }
        @endphp
        //動態載入表格之前，先銷毀表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'date', title: '日期', sortable: true,footerFormatter:"總計(小時)",align:'center',valign:'middle'},
            {field: '特休', title: '特休', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].特休)
                        sum += counts;
                    }
                    return sum;
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.特休!="0")
                        t=row.特休;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '公假', title: '公假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].公假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.公假!="0")
                        t=row.公假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '事假', title: '事假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].事假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.事假!="0")
                        t=row.事假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '病假', title: '病假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].病假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.病假!="0")
                        t=row.病假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '公傷病假', title: '公傷<br>病假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].公傷病假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.公傷病假!="0")
                        t=row.公傷病假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '婚假', title: '婚假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].婚假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.婚假!="0")
                        t=row.婚假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '產假', title: '產假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].產假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.產假!="0")
                        t=row.產假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '陪產假', title: '陪產<br>假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].陪產假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.陪產假!="0")
                        t=row.陪產假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '喪假', title: '喪假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].喪假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.喪假!="0")
                        t=row.喪假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '生理假', title: '生理<br>假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].生理假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.生理假!="0")
                        t=row.生理假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '補假', title: '補假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].補假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.補假!="0")
                        t=row.補假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '防疫照顧假', title: '防疫照顧假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].防疫照顧假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.防疫照顧假!="0")
                        t=row.防疫照顧假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '家庭照顧假', title: '家庭照顧假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].家庭照顧假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.家庭照顧假!="0")
                        t=row.家庭照顧假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '防疫隔離假', title: '防疫隔離假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].防疫隔離假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.防疫隔離假!="0")
                        t=row.防疫隔離假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '疫苗接種假', title: '疫苗接種假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].疫苗接種假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.疫苗接種假!="0")
                        t=row.疫苗接種假;
                    else
                        t="-";
                    return t;
                }
            },
        ];
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: true,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'date', // 預設排序
        });

        $('#tableL01').bootstrapTable('hideColumn', '防疫照顧假')
        $('#tableL01').bootstrapTable('hideColumn', '家庭照顧假')
        $('#tableL01').bootstrapTable('hideColumn', '防疫隔離假')
        $('#tableL01').bootstrapTable('hideColumn', '疫苗接種假')
    </script>
    {{--日期選擇設定--}}
    <!-- 起始時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- 結束時間 (datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
        <!-- 選擇年分 (datetimepicker3物件) -->
        <script type="text/javascript">
            $(function () {
                $('#datetimepicker3').datetimepicker({
                    locale:'zh-tw',
                    // format: 'YYYY-MM-DD a hh:mm:ss ',
                    format: 'YYYY',
                    weekStart: 1,
                    autoclose: 1,
                    todayHighlight: 1,
                    inline:false,
                    allowInputToggle:true,
                    sideBySide:false,
                    stepping:0,
                    minView:0,
                    maxView:0,
                    maxDate:new Date(),
                    startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                    date: new Date("{{ old('end',date("Y")) }}") // 初始化日期
                });
            });
        </script>
@endsection
