@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
<link rel="stylesheet" href="/css/selectize.min.css" />
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
<script src="/js/selectize.min.js"></script>


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '17'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 7vh;align-items: center">
                            @if($type=="2")
                                {{--datetime 起始時間選擇--}}
                                <div class="col-3">
                                    <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">起始時間</div>
                                        </div>
                                        <input id="overtime_start" style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                        <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                                {{--datetime 結束時間選擇--}}
                                <div class="col-3">
                                    <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">結束時間</div>
                                        </div>
                                        <input id="overtime_end" style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                        <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_overtime()">查詢</button>
                                </div>
                            @else
                                <div class="col-9">
                                    <p class="h5"><strong>請於當日17:30前提出申請。</strong></p>
                                    <p class="h6">18:00過後下班者，請填加班申請，未填寫者將不發放加班費。</p>
                                    <p class="h6">申請加班，必須應事實之需要，不得浮濫，如有虛報，一經查明，除依法嚴懲當事人外，其主管亦應負監督不周之責。</p>
                                </div>
                            @endif
                    </div>
                    <div class="row" style="height: 7vh;align-items: center">
                        <div class="col-3"></div>
                        <div class="col-3">
                            @if($type=="2")
                                    <select style="text-align: center"  id="person_choose" placeholder="請選擇姓名" name="person">
                                        <option value=""></option>
                                        @foreach($persons as $person)
                                            @if(isset($person_id))
                                                @if($person["id"]==old('person'))
                                                    <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                                @else
                                                    <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                                @endif
                                            @else
                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                            @endif
                        </div>
                        <div class="col-3">
                            @if($type=="2")
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_overtime_personal()">查詢個人</button>
                            @endif
                        </div>
                        <div class="col-3 float-right">
                            @if($check=="沒超過")
                                <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertOvertime">新增加班</button>
                            @endif
                                <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="javascript:location.href='{{ Route("overtime_all") }}'">查看所有加班紀錄</button>
                        </div>
                    </div>
                    {{--表格呈現-加班列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 新增加班彈出視窗 --}}
    <div class="modal fade" id="InsertOvertime" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增加班</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("insert_overtime") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <label for="selectPerson" style="text-align: right" class="col-3 col-form-label">加班人員姓名</label>
                                <div class="col-9">
                                    @if($level=="1")
                                        <input readonly id='person' name="person" style="text-align: center"  type="hidden" class="form-control" value="{{$person_id}}" >
                                        <input readonly style="text-align: center"  type="text" class="form-control" value="{{$person_name}}" >
                                    @else
                                        <select class="custom-select form-control" id="selectPerson" name="person">
                                            <option disabled selected>請選擇姓名</option>
                                            @foreach($persons as $person)
                                                @if($person["id"]==$person_id)
                                                    <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                                @else
                                                    <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="department" >部門</label>
                                <div class="col-9">
                                    @if($level=="1")
                                        <input readonly id='department' name="department" style="text-align: center"  type="hidden" class="form-control" value="{{$user_department}}" >
                                        <input readonly  style="text-align: center"  type="text" class="form-control" value="{{$department_name}}" >
                                    @else
                                        <select class="custom-select form-control" id="inputDepartment" name="department" required>
                                            <option selected disabled >請選擇部門</option>
                                            @foreach($departments as $department)
                                                @if($department["no"]==$user_department)
                                                    <Option value="{{ $department["no"] }}" selected>{{ $department["department"] }}</Option>
                                                @else
                                                    <Option value="{{ $department["no"] }}">{{ $department["department"] }}</Option>
                                                @endif
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="start_time" style="text-align: right" class="col-3 col-form-label">加班時間</label>
                                <div class="col-9">
                                    <div style="background: white"  class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                        <input id='start_time' style="text-align: center" name="start_time" type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker3"onblur="date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <label class="input-group-text">~</label>
                                    </div>
                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                        <input id='end_time' style="text-align: center" name="end_time" style="text-align: center" type="text" class="col-4 form-control datetimepicker-input" data-target="#datetimepicker4" onblur="date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="hour" >加班時長</label>
                                <div class="col-3">
                                    <input id='hour' name="hour" style="text-align: center"  type="number" class="form-control" step="0.5">
                                </div>
                                <label style="text-align: right;" class="col-3 col-form-label" for="day_category" >加班日類型</label>
                                <div class="col-3">
                                    <select class="custom-select form-control" name="day_category" required="required">
                                        <option disabled >請選擇類型</option>
                                        <option value="工作日" selected>工作日</option>
                                        <option value="休假日">休假日</option>
                                        <option value="例假日">例假日</option>
                                        <option value="國定假日">國定假日</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="reason" >原因</label>
                                <div class="col-9">
                                    <input id='reason' name="reason" style="text-align: center"  type="text" class="form-control" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="substitute" >是否有鑰匙</label>
                                <div class="col-3">
                                    <select class="custom-select form-control" name="is_key" required="required">
                                        <option disabled >請選擇</option>
                                        <option value="有">有鑰匙</option>
                                        <option value="沒有" selected>沒有鑰匙</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary" id="insert_btn">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 修改加班彈出視窗 --}}
    <div class="modal fade" id="ModifyOvertime" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改加班資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("update_overtime") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-sm-12">
                            <div class="form-group row">
                                <input id='no' name="no" style="text-align: center" type="hidden">
                                <label for="selectPerson" style="text-align: right" class="col-sm-3 col-form-label">加班人員姓名</label>
                                <div class="col-sm-9">
                                    <input readonly id='midify_person' name="person" style="text-align: center" class="form-control" type="hidden">
                                    <input readonly id='modify_personname'  style="text-align: center"  type="text" class="form-control" >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="department" >部門</label>
                                <div class="col-sm-9">
                                    <input readonly id='modify_department' name="department" style="text-align: center"  type="hidden" class="form-control">
                                    <input readonly id='modify_department_name' style="text-align: center"  type="text" class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="start_time" style="text-align: right" class="col-sm-3 col-form-label">加班時間</label>
                                <div class="col-9">
                                    <div style="background: white"  class="input-group date" id="datetimepicker5" data-target-input="nearest">
                                        <input id='modify_start_time' style="text-align: center" name="start_time" type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker5" onblur="update_date()"required/>
                                        <div class="input-group-append" data-target="#datetimepicker5" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <label class="input-group-text">~</label>
                                    </div>
                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker6" data-target-input="nearest">
                                        <input id='modify_end_time' name="end_time" style="text-align: center" type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker6" onblur="update_date()" required/>
                                        <div class="input-group-append" data-target="#datetimepicker6" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="hour" >加班時長</label>
                                <div class="col-sm-3">
                                    <input id='modify_hour' name="hour" style="text-align: center"  type="number" class="form-control" step="0.5">
                                </div>
                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="day_category" >加班日類型</label>
                                <div class="col-sm-3">
                                    {{--                                                <input id='day_category' name="day_category" style="text-align: center"  type="text" class="form-control">--}}
                                    <select class="custom-select form-control" id="selectDayCategory" name="day_category" required="required">
                                        <option disabled selected>請選擇類型</option>
                                        <option value="工作日">工作日</option>
                                        <option value="休假日">休假日</option>
                                        <option value="例假日">例假日</option>
                                        <option value="國定假日">國定假日</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="reason" >原因</label>
                                <div class="col-sm-9">
                                    <input id='modify_reason' name="reason" style="text-align: center"  type="text" class="form-control" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="substitute" >是否有鑰匙</label>
                                <div class="col-sm-3">
                                    {{--                                                <input id='substitute' name="substitute" style="text-align: center"  type="text" class="form-control">--}}
                                    <select class="custom-select form-control" id="selectIsKey" name="is_key" required="required">
                                        <option disabled selected>請選擇</option>
                                        <option value="有">有鑰匙</option>
                                        <option value="沒有">沒有鑰匙</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary" id="update_btn">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        //新增加班時間計算
        function date()
        {

            var start = document.getElementById("start_time");
            var end = document.getElementById("end_time");
            if(start.value!=null && end.value!=null)
            {
                var hour = document.getElementById("hour");
                var d1 = new Date(start.value);
                var d2 = new Date(end.value);
                var time=d2-d1;
                var time_hour=time/1000/60/60;
                var time_day=time/1000/60/60/24;
                for(i=1;i<time_day;i++){
                    time_hour=time_hour-15;
                }
                if(time_hour>8)
                {
                    time_day++;
                    if(time_hour%9!=0)
                    {
                        time_day--;
                        if(d1.getHours()<=12 && d2.getHours()>=13)
                            time_hour--;
                    }
                }
                else
                {
                    if(d1.getHours()<=12 && d2.getHours()>=13)
                        time_hour--;
                }
                hour.value=time_hour-(parseInt(time_day));
                if(time_hour<0)
                {
                    alert("時間有錯，結束時間要大於開始時間");
                    document.getElementById("insert_btn").disabled=true;
                }
                else
                    document.getElementById("insert_btn").disabled=false;
            }
        }
        //修改加班時間計算
        function update_date()
        {
            var start = document.getElementById("modify_start_time");
            var end = document.getElementById("modify_end_time");
            if(start.value!=null && end.value!=null)
            {
                var hour = document.getElementById("modify_hour");
                var d1 = new Date(start.value);
                var d2 = new Date(end.value);
                var time=d2-d1;
                var time_hour=time/1000/60/60;
                var time_day=time/1000/60/60/24;
                for(i=1;i<time_day;i++){
                    time_hour=time_hour-15;
                }
                if(time_hour>8)
                {
                    time_day++;
                    if(time_hour%9!=0)
                    {
                        time_day--;
                        if(d1.getHours()<=12 && d2.getHours()>=13)
                            time_hour--;
                    }
                }
                else
                {
                    if(d1.getHours()<=12 && d2.getHours()>=13)
                        time_hour--;
                }
                hour.value=time_hour-(parseInt(time_day));
                if(time_hour<0)
                {
                    alert("時間有錯，結束時間要大於開始時間");
                    document.getElementById("update_btn").disabled=true;
                }
                else
                    document.getElementById("update_btn").disabled=false;
            }
        }
    </script>
    <script>
        // 修改加班
        function overtime_modify(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("no").value=jdata[jdata_index].no;
            document.getElementById("midify_person").value=jdata[jdata_index].id;
            document.getElementById("modify_personname").value=jdata[jdata_index].name;
            document.getElementById("modify_department").value=jdata[jdata_index].department_id;
            document.getElementById("modify_hour").value=jdata[jdata_index].hour;
            document.getElementById("selectDayCategory").value=jdata[jdata_index].day_category;
            document.getElementById("modify_reason").value=jdata[jdata_index].reason;
            document.getElementById("selectIsKey").value=jdata[jdata_index].is_key;
            document.getElementById("modify_start_time").value=jdata[jdata_index].start_time;
            document.getElementById("modify_end_time").value=jdata[jdata_index].end_time;
            document.getElementById("modify_department_name").value=jdata[jdata_index].department_name;
        }
        //匯出加班
        function overtime_word(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var overtime_no=jdata[jdata_index].no;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_overtime") }}");
            var id = document.createElement("input");
            id.setAttribute("type", "hidden");
            id.setAttribute("name", "overtime_id");
            id.setAttribute("value",overtime_no);
            form.appendChild(id);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        //尋找加班
        function select_overtime() {
            var start=document.getElementById("overtime_start").value;
            var end=document.getElementById("overtime_end").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("select_overtime") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        //尋找個人加班
        function select_overtime_personal() {
            var start=document.getElementById("overtime_start").value;
            var end=document.getElementById("overtime_end").value;
            var person=document.getElementById("person_choose").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("select_overtime_personal") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var select_person = document.createElement("input");
            select_person.setAttribute("type", "hidden");
            select_person.setAttribute("name", "person");
            select_person.setAttribute("value",person);
            form.appendChild(select_person);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        {{--取得已選取目標--}}
        function getIdSelections() {
            // let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            // document.getElementById("leave_no").value=jdata[jdata_index].no;
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        {{--刪除加班--}}
        function delete_overtime(obj) {
            let idselections=getIdSelections();
            if(idselections!="")
            {
                if(confirm("是否刪除"+idselections)){
                    var form = document.createElement("form");
                    form.setAttribute("method","post");
                    form.setAttribute("action","{{ Route("delete_overtime") }}");
                    var idselectionsField = document.createElement("input");
                    idselectionsField.setAttribute("type", "hidden");
                    idselectionsField.setAttribute("name", "selectedId");
                    idselectionsField.setAttribute("value",idselections);
                    form.appendChild(idselectionsField);
                    var csrfField=document.createElement("input");
                    csrfField.setAttribute("type", "hidden");
                    csrfField.setAttribute("name", "_token");
                    csrfField.setAttribute("value", "{{ csrf_token() }}");
                    form.appendChild(csrfField);
                    document.body.appendChild(form);    // Not entirely sure if this is necessary
                    form.submit();
                }
            }
            else
            {
                alert("請勾選要刪除的資料");
            }

        }
    </script>
    {{--下拉式選單-藉由輸入快速選擇(selectize)--}}
    <script>
        $(document).ready(function () {
            $('#person_choose').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    {{--跳出錯誤訊息--}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--下拉式選單-藉由輸入快速選擇(selectize)--}}
    <script>
        // 載入資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷毀表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'state', checkbox: true,},
            {field: 'name',title: '人員名稱', sortable: true,footerFormatter:"總計"},
            {field: 'date',title: '日期', sortable: true,
                footerFormatter:function (rows){
                    return "共"+rows.length+"筆";
                }},
            {field: 'start', title: '開始時間', sortable: true,
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].hour)
                        sum += counts;
                    }
                    return "共"+sum+"小時";
                }},
            {field: 'end', title: '結束時間', sortable: true,
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].hour)
                        sum += counts;
                    }
                    var average=sum/rows.length;
                    average=average.toFixed(2);
                    if(rows.length==0)
                        average=0;
                    return "平均"+average+"小時";
                }},
            {field: 'is_key', title: '是否有鑰匙', sortable: true},
            {field: 'status', title: '審核狀態', sortable: true},
            {field: 'modify', title: '修改', sortable: false},
            {field: 'delete', title: '刪除', sortable: false},
            {field: 'export', title: '', sortable: false},
        ];
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: {{$check_c}},
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            multipleSelectRow: true,
            sortName:'date', // 預設排序
            sortOrder:'desc',
        });
    </script>
    {{--日期選擇設定--}}
    <!-- 起始時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- 結束時間 (datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
    <!-- 加班時間 (datetimepicker3物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                // format: 'YYYY/MM/DD hh:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                minDate:new Date(),
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y/m/d")." 17:30") }}"), // 初始值
            });
        });
    </script>
    <!-- 加班時間 (datetimepicker4物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker4').datetimepicker({
                locale:'ru',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                // format: 'YYYY/MM/DD hh:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                minDate:new Date(),
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end_time',date("Y/m/d")) }}") // 初始化日期
            });
        });
    </script>

@endsection
