@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/bootstrap-table.js"></script>
    {{--引入 datetimepicker 相關套件--}}
    <script type="text/javascript" src="/bower_components/moment/moment.js"></script>
    <script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 30%;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 50vh !important;
        }
    </style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("search") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">人員查詢</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" onclick="javascript:location.href='{{ route('show_camera',["id"=>$camera['id']]) }}'">
                                                        {{ $camera["name"] }}
                                                    </button>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>

            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-8" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-4 text-center"><a href="{{ Route("AI") }}" style="text-decoration:none;color: #1b1e21;">即時監控</a></div>
                    <div class="col-4 text-center"><a href="{{ Route("camera") }}" style="text-decoration:none;color: #1b1e21;">設備管理</a></div>
                    <div class="col-4 text-center">人員查詢</div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <form id="send" action="{{route('searchp')}}" method="POST">
                        @csrf
                        <label>選擇時段：</label>

                                <div style="background: white"  class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>

{{--                                <span id="arg" style="color: black">直到~~</span>--}}
                            <label>直到~</label>

                            <div style="background: white" class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>

                        <div class="row" style="height: 10vh;align-items: center">
                            <div class="col-9">
                                <label>搜尋：</label>
                                <select>
                                    <option value="id">ID</option>
                                    <option value="name">姓名</option>
                                    <option value="class">類別</option>
                                </select>
                                <label>=</label>
                                <input type="search" name="id" required>
                                <button type="submit">搜尋</button>
                            </div>
                        </div>
                    </form>

                    <div class="fixed-table-container"></div>
                    {{--查詢人員資訊區--}}
                    <div style="height: 50vh">
                        <div class="table-responsive">
                            <table class="table table-bordered fixed-height" style="table-layout: fixed" id="table" data-toggle="table" data-height="100px">
                                <thead>
                                <tr>
{{--                                    <th scope="col"><div><input type="checkbox" class="checkbox"></div></th>--}}
                                    <th scope="col">日期</th>
                                    <th scope="col">時間</th>
                                    <th scope="col">姓名</th>
                                    <th scope="col">照片</th>
                                    <th scope="col">相似度</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if ($data != '查無資料')
                                    @foreach($data as $d)
                                        <tr>
                                            <td scope="row">{{ explode(" ", $d[$time])[0] }}</td>
                                            <td>{{ explode(" ", $d[$time])[1] }}</td>
                                            <td>{{ $d[$id] }}</td>
                                            <td><img class="faceimg" src="{{ $imgserver.$d[$snapshot] }}"></td>
                                            <td>{{ $d[$score] }}</td>
                                        </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <th scope="row"><input type="checkbox" class="checkbox"></th>
                                        <td>{{$data}}</td>
                                        <td>{{$data}}</td>
                                        <td>{{$data}}</td>
                                        <td>{{$data}}</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            {{--攝影機 辨識結果區--}}
            <div id="face-aria" class="col-md-2" style="height: 100vh;overflow-y: scroll;background-color: black;">
                <ul id="face-box" class="list-unstyled" style="padding-top: 10%">
                    <li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">
                        <img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">
                        <div class="media-body">
                            <p class="information">2019-12-20</p>
                            <p class="information">18:03:15</p>
                            <p class="information">姓名：Allen</p>
                            <p class="information">相似度：87%</p>
                        </div>
                    </li>
                    <li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">
                        <img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">
                        <div class="media-body">
                            <p class="information">2019-12-20</p>
                            <p class="information">18:03:15</p>
                            <p class="information">姓名：Allen</p>
                            <p class="information">相似度：87%</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif

    {{--刪除按鈕事件處理--}}
    <script>
        function drop_camera() {
            var id=document.getElementById("cameraid").value;
            if(confirm("是否刪除"+id)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("drop_camera") }}");
                var idField = document.createElement("input");
                idField.setAttribute("type", "hidden");
                idField.setAttribute("name", "id");
                idField.setAttribute("value",id);
                form.appendChild(idField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
    </script>


    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD a hh:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:true,
                allowInputToggle:true,
                sideBySide:true,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>

    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD a hh:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:true,
                allowInputToggle:true,
                sideBySide:true,
                stepping:0,
                minView:0,
                maxView:0,
                useCurrent:false,
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });

            $("#datetimepicker1").on("change.datetimepicker", function (e) {
                $('#datetimepicker2').datetimepicker("minDate",e.date);
            });
            $("#datetimepicker2").on("change.datetimepicker", function (e) {
                $('#datetimepicker1').datetimepicker("maxDate",e.date);
            });

            $('#datetimepicker1').datetimepicker("hide");
            $('#datetimepicker2').datetimepicker("hide");
        });
    </script>
@endsection
