import os, time, subprocess

env = os.environ

in_host = env['RTSP_HOST']

in_port = int(env['RTSP_PORT'])

in_key = env['RTSP_KEY'] if 'RTSP_KEY' in env else None

out_host = env['RTMP_HOST']

out_port = int(env['RTMP_PORT'])

out_key = env['RTMP_KEY'] if 'RTMP_KEY' in env else None

# out_fps = int(env['EADA_FPS']) if 'EADA_FPS' in env else 30

rtsp_in = 'rtsp://{0}:{1}'.format(in_host, in_port)

rtsp_in = "{0}/{1}".format(rtsp_in, in_key) if in_key is not None else rtsp_in

rtmp_out = 'rtmp://{0}:{1}'.format(out_host, out_port)

rtmp_out = "{0}/{1}".format(rtmp_out, out_key) if out_key is not None else rtmp_out

ffmpeg = [
            'ffmpeg',                 # Transfer real-time stream to media server
            '-report',                # Ouput ffmpeg info
            '-loglevel', 'quiet',     # Hide ffmpeg extra info
            '-rtsp_transport', 'tcp', # The protocol of source stream
            # '-r', str(in_fps),        # Input video frame count
            '-i', rtsp_in,            # The URL of source stream
            '-c:v', 'copy',           # Output video encoding
            '-an',                    # Output audio encoding 指定輸出聲音編碼 (an: 無聲音)
#             '-rtsp_transport', 'tcp', # The protocol of destination stream
            # '-r', str(out_fps),       # Output video frame count
            '-f','flv', rtmp_out,    # The URL of destination stream
        ]
print(" ".join(ffmpeg))
p = subprocess.call(ffmpeg)