from base_resource import BaseResource
from department_model import DepartmentModel

# ========== 新增部門 ==========
class DepartmentInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDepartment")
        self.parser.add_argument('department', help="部門")
    def post(self):
        args = self.parser.parse_args()
        model = DepartmentModel.FromDBByDepartment(args['department'], self.log.SetMessage)
        if not model.isExist:
            model.SetDepartment(args['department'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "Department：{0} inserted".format(args['department'])
            else:
                self.message = "Department：{0} insert failed".format(args['department'])
        else:
            self.message = "Department：{0} is exist in database".format(args['department'])
        return self.GetResponse()

# ========== 更新部門 ==========
class DepartmentUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDepartment")
        self.parser.add_argument('no', required=True, help="部門編號")        
        self.parser.add_argument('department', help="部門")
    def post(self):
        args = self.parser.parse_args()
        model = DepartmentModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetDepartment(args['department'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeDepartment():
                    self.message.append(
                        "Department: {0} -> {1}".format(model.GetOldDepartment(), model.GetDepartment())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Department：{0} update failed".format(args['department'])
        else:
            self.message = "Department：{0} isn't exist in database".format(args['department'])
        return self.GetResponse()
# ========== 刪除部門 ==========
class DepartmentDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDepartment")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DepartmentModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['no'])
        else:
            self.message = "{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有部門 ==========
class DepartmentSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectDepartment")
    def post(self, ID=None):
        models = DepartmentModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    