from base_resource import BaseResource
from mysql_model import DeviceGroupRelationModel,DeviceGroupModel,DeviceModel

# 針對設備與群組的關聯只有加入或退出群組關聯，無更新方法
# ========== 新增裝置與群組資源 ==========
class DeviceGroupRelationInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDeviceGroupRelation")
        self.parser.add_argument('device_id', required=True, help="設備編號，上限 15 字")
        self.parser.add_argument('device_group_id', required=True, help="群組編號，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        device_model = DeviceModel.FromDB(args['device_id'], self.log.SetMessage)
        group_model = DeviceGroupModel.FromDB(args['device_group_id'], self.log.SetMessage)
        
        if device_model.isExist and group_model.isExist:
            relation_model=DeviceGroupRelationModel.FromDB(args['device_id'],args['device_group_id'], self.log.SetMessage)
            if not relation_model.isExist:
                if relation_model.InsertToDB(self.log.SetMessage):
                    self.message = "device {} and group {} relation inserted".format(args['device_id'],args['device_group_id'])
                else:
                    self.message =  "device {} and group {} relation insert failed".format(args['device_id'],args['device_group_id'])
            else:
                    self.message = "device {} and group {} relation is exist in database".format(args['device_id'],args['device_group_id'])
        else:
            self.message = "device {} or group {} is not exist in database".format(args['device_id'],args['device_group_id'])
        return self.GetResponse()

# ========== 更新裝置資源 ==========
# class DeviceGroupRelationUpdate(BaseResource):
#     def __init__(self):
#         super().__init__("UpdateDeviceGroupRelation")
#         self.parser.add_argument('id', required=True, help="設備群組編號")
#         self.parser.add_argument('name', help="設備群組名稱，上限 15 字")
#     def post(self):
#         args = self.parser.parse_args()
#         model = DeviceGroupModel.FromDB(args['id'], self.log.SetMessage)
#         if model.isExist:
#             model.SetName(args['name'])
#             if model.UpdateToDB(self.log.SetMessage):
#                 self.message = []
#                 if model.HasChangeName():
#                     self.message.append(
#                         "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
#                     )
#                 self.message = ", ".join(self.message) if len(self.message) > 0 else ""
#             else:
#                 self.message = "{0} failed".format(args['id'])
#         else:
#             self.message = "{0} isn't exist in database".format(args['id'])
#         return self.GetResponse()
# ========== 刪除裝置資源 ==========
class DeviceGroupRelationDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDeviceGroupRelation")
        self.parser.add_argument('device_id', required=True, help="設備編號，上限 15 字")
        self.parser.add_argument('device_group_id', required=True, help="群組編號，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceGroupRelationModel.FromDB(args['device_id'],args['device_group_id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "device {} and group {} relation deleted".format(args['device_id'],args['device_group_id'])
            else:
                self.message = "device {} and group {} relation delete failed".format(args['device_id'],args['device_group_id'])
        else:
            self.message = "device {} or group {} is not exist in database".format(args['device_id'],args['device_group_id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class DeviceGroupRelationSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllDeviceGroupRelation")
    def post(self, ID=None):
        models = DeviceGroupRelationModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()