from base_resource import BaseResource
from mysql_model import DeviceModel,PersonModel

# ========== 更新裝置資源 ==========
class DeviceUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDevice")
        self.parser.add_argument('id', required=True, help="上限 15 字")
        self.parser.add_argument('host', help="IPv4")
        self.parser.add_argument('port', help="上限 65535")
        self.parser.add_argument('location', help="上限 20 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceModel.FromDB(args['id'],self.log.SetMessage)
        if model.isExist:
            model.SetHost(args['host'])
            model.SetPort(args['port'])
            model.SetLocation(args['location'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeHost():
                    self.message.append(
                        "Host: {0} -> {1}".format(model.GetOldHost(), model.GetHost())
                    )
                if model.HasChangePort():
                    self.message.append(
                        "Port: {0} -> {1}".format(model.GetOldPort(), model.GetPort())
                    )
                if model.HasChangeLocatoin():
                    self.message.append(
                        "Location: {0} -> {1}".format(model.GetOldLocation(), model.GetLocation())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "{0} failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 刪除裝置資源 ==========
class DeviceDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDevice")
        self.parser.add_argument('id', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DeviceModel.FromDB(args['id'],self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['id'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class DeviceSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllDevice")
    def get(self, ID=None):
        models = DeviceModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()
    
# ========== 人員新增進設備 ==========
class PersonToDeviceInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertPersonToDevice")
        self.parser.add_argument('id', required=True, help="上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceModel.FromDB(args['id'],self.log.SetMessage)
        person = PersonModel.AllFromDB(self.log.SetMessage)
        insert = []
        not_insert = []
        no_photo = []
        if model.isExist:
            for p in person:
                if(p.GetPhoto() is not None):
                    if model.InsertToDevice(p):
                        insert.append(p.GetID())
                    else:
                        not_insert.append(p.GetID())
                else:
                    no_photo.append(p.GetID())
            self.message = "{0} person inserted, {1} person insert failed, {2}；{3} person no photo, {4}".format(len(insert), len(not_insert), ', '.join(not_insert), len(no_photo), ', '.join(no_photo))
        else:
            self.message = "{0} is not exist in database".format(args['id'])
        return self.GetResponse()