from base_resource import BaseResource
from features_model import FeaturesModel
# from werkzeug.datastructures import FileStorage
import os, werkzeug, base64, pandas as pd

# ========== 新增功能記錄 ==========
class FeaturesInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertFeatures")
        self.parser.add_argument('major_title', required=True, help="功能主要標籤，上限15字")
        self.parser.add_argument('name', required=True, help="功能名稱，上限15字")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesModel.FromDBByName(args['name'], self.log.SetMessage)
        if not model.isExist:
            model.SetMajorTitle(args['major_title'])
            model.SetName(args['name'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "Features：{0} inserted".format(args['name'])
            else:
                self.message = "Features：{0} insert failed".format(args['name'])
        else:
            self.message = "Features：{0} is exist in database".format(args['name'])
        return self.GetResponse()

# ========== 更新功能紀錄 ==========
class FeaturesUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateFeatures")
        self.parser.add_argument('no', required=True, help="功能編號")
        self.parser.add_argument('major_title', required=True, help="功能主要標籤，上限15字")
        self.parser.add_argument('name', required=True, help="功能名稱，上限15字")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetMajorTitle(args['major_title'])
            model.SetName(args['name'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeMajorTitle():
                    self.message.append(
                        "MajorTitle: {0} -> {1}".format(model.GetOldMajorTitle(), model.GetMajorTitle())
                    )
                if model.HasChangeName():
                    self.message.append(
                        "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Features：{0} update failed".format(args['name'])
        else:
            self.message = "Features：{0} isn't exist in database".format(args['name'])
        return self.GetResponse()
# ========== 刪除功能紀錄 ==========
class FeaturesDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteFeatures")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "Features：{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "Features：{0} delete failed".format(args['no'])
        else:
            self.message = "Features：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有功能紀錄 ==========
class FeaturesSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectFeatures")
    def post(self, ID=None):
        models = FeaturesModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    