/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.HttpClient;
import okhttp3.benchmarks.SynchronousHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;

class OkHttpAsync
implements HttpClient {
    private static final boolean VERBOSE = false;
    private final AtomicInteger requestsInFlight = new AtomicInteger();
    private OkHttpClient client;
    private Callback callback;
    private int concurrencyLevel;
    private int targetBacklog;

    OkHttpAsync() {
    }

    @Override
    public void prepare(Benchmark benchmark) {
        this.concurrencyLevel = benchmark.concurrencyLevel;
        this.targetBacklog = benchmark.targetBacklog;
        this.client = new OkHttpClient.Builder().protocols(benchmark.protocols).dispatcher(new Dispatcher((ExecutorService)new ThreadPoolExecutor(benchmark.concurrencyLevel, benchmark.concurrencyLevel, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()))).build();
        if (benchmark.tls) {
            HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
            SSLSocketFactory socketFactory = handshakeCertificates.sslSocketFactory();
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession session) {
                    return true;
                }
            };
            this.client = this.client.newBuilder().sslSocketFactory(socketFactory, handshakeCertificates.trustManager()).hostnameVerifier(hostnameVerifier).build();
        }
        this.callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                System.out.println("Failed: " + e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody body = response.body();
                long total = SynchronousHttpClient.readAllAndClose(body.byteStream());
                long finish = System.nanoTime();
                OkHttpAsync.this.requestsInFlight.decrementAndGet();
            }
        };
    }

    @Override
    public void enqueue(HttpUrl url) throws Exception {
        this.requestsInFlight.incrementAndGet();
        this.client.newCall(new Request.Builder().tag((Object)System.nanoTime()).url(url).build()).enqueue(this.callback);
    }

    @Override
    public synchronized boolean acceptingJobs() {
        return this.requestsInFlight.get() < this.concurrencyLevel + this.targetBacklog;
    }
}

