/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.HttpClient;

abstract class SynchronousHttpClient
implements HttpClient {
    ThreadPoolExecutor executor;
    int targetBacklog;

    SynchronousHttpClient() {
    }

    @Override
    public void prepare(Benchmark benchmark) {
        this.targetBacklog = benchmark.targetBacklog;
        this.executor = new ThreadPoolExecutor(benchmark.concurrencyLevel, benchmark.concurrencyLevel, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void enqueue(HttpUrl url) {
        this.executor.execute(this.request(url));
    }

    @Override
    public boolean acceptingJobs() {
        return this.executor.getQueue().size() < this.targetBacklog;
    }

    static long readAllAndClose(InputStream in) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        long total = 0L;
        while ((count = in.read(buffer)) != -1) {
            total += (long)count;
        }
        in.close();
        return total;
    }

    abstract Runnable request(HttpUrl var1);
}

