/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.config.InstrumentConfig;
import com.google.caliper.config.InvalidConfigurationException;
import com.google.caliper.config.ResultProcessorConfig;
import com.google.caliper.config.VmConfig;
import com.google.caliper.util.Util;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class CaliperConfig {
    @VisibleForTesting
    final ImmutableMap<String, String> properties;
    private final ImmutableMap<Class<? extends ResultProcessor>, ResultProcessorConfig> resultProcessorConfigs;
    private static final Pattern CLASS_PROPERTY_PATTERN = Pattern.compile("(\\w+)\\.class");
    private static final Pattern INSTRUMENT_CLASS_PATTERN = Pattern.compile("([^\\.]+)\\.class");
    private static final Splitter ARGS_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    @VisibleForTesting
    public CaliperConfig(ImmutableMap<String, String> properties) throws InvalidConfigurationException {
        this.properties = (ImmutableMap)Preconditions.checkNotNull(properties);
        this.resultProcessorConfigs = CaliperConfig.findResultProcessorConfigs(CaliperConfig.subgroupMap(properties, "results"));
    }

    private static <T> ImmutableBiMap<String, Class<? extends T>> mapGroupNamesToClasses(ImmutableMap<String, String> groupProperties, Class<T> type) throws InvalidConfigurationException {
        HashBiMap namesToClasses = HashBiMap.create();
        for (Map.Entry entry : groupProperties.entrySet()) {
            Matcher matcher = CLASS_PROPERTY_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || ((String)entry.getValue()).isEmpty()) continue;
            try {
                Class<?> someClass = Class.forName((String)entry.getValue());
                Preconditions.checkState((boolean)type.isAssignableFrom(someClass));
                Class<?> verifiedClass = someClass;
                namesToClasses.put((Object)matcher.group(1), verifiedClass);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigurationException("Cannot find result processor class: " + (String)entry.getValue());
            }
        }
        return ImmutableBiMap.copyOf((Map)namesToClasses);
    }

    private static ImmutableMap<Class<? extends ResultProcessor>, ResultProcessorConfig> findResultProcessorConfigs(ImmutableMap<String, String> resultsProperties) throws InvalidConfigurationException {
        ImmutableBiMap<String, Class<ResultProcessor>> processorToClass = CaliperConfig.mapGroupNamesToClasses(resultsProperties, ResultProcessor.class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : processorToClass.entrySet()) {
            builder.put(entry.getValue(), (Object)CaliperConfig.getResultProcessorConfig(resultsProperties, (String)entry.getKey()));
        }
        return builder.build();
    }

    public ImmutableMap<String, String> properties() {
        return this.properties;
    }

    public VmConfig getDefaultVmConfig() {
        return new VmConfig.Builder(new File(System.getProperty("java.home"))).addAllOptions(ManagementFactory.getRuntimeMXBean().getInputArguments()).addAllOptions(CaliperConfig.getArgs(CaliperConfig.subgroupMap(this.properties, "vm"))).build();
    }

    public VmConfig getVmConfig(String name) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap<String, String> vmGroupMap = CaliperConfig.subgroupMap(this.properties, "vm");
        ImmutableMap<String, String> vmMap = CaliperConfig.subgroupMap(vmGroupMap, name);
        File homeDir = CaliperConfig.getJdkHomeDir((String)vmGroupMap.get((Object)"baseDirectory"), (String)vmMap.get((Object)"home"), name);
        return new VmConfig.Builder(homeDir).addAllOptions(CaliperConfig.getArgs(vmGroupMap)).addAllOptions(CaliperConfig.getArgs(vmMap)).build();
    }

    public ImmutableSet<String> getConfiguredInstruments() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String key : CaliperConfig.subgroupMap(this.properties, "instrument").keySet()) {
            Matcher matcher = INSTRUMENT_CLASS_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            resultBuilder.add((Object)matcher.group(1));
        }
        return resultBuilder.build();
    }

    public InstrumentConfig getInstrumentConfig(String name) {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap<String, String> instrumentGroupMap = CaliperConfig.subgroupMap(this.properties, "instrument");
        ImmutableMap<String, String> insrumentMap = CaliperConfig.subgroupMap(instrumentGroupMap, name);
        String className = (String)insrumentMap.get((Object)"class");
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (String)"no instrument configured named %s", (Object[])new Object[]{name});
        return new InstrumentConfig.Builder().className(className).addAllOptions((Map<String, String>)CaliperConfig.subgroupMap(insrumentMap, "options")).build();
    }

    public ImmutableSet<Class<? extends ResultProcessor>> getConfiguredResultProcessors() {
        return this.resultProcessorConfigs.keySet();
    }

    public ResultProcessorConfig getResultProcessorConfig(Class<? extends ResultProcessor> resultProcessorClass) {
        return (ResultProcessorConfig)this.resultProcessorConfigs.get(resultProcessorClass);
    }

    private static ResultProcessorConfig getResultProcessorConfig(ImmutableMap<String, String> resultsProperties, String name) {
        ImmutableMap<String, String> resultsMap = CaliperConfig.subgroupMap(resultsProperties, name);
        return new ResultProcessorConfig.Builder().className((String)resultsMap.get((Object)"class")).addAllOptions((Map<String, String>)CaliperConfig.subgroupMap(resultsMap, "options")).build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }

    private static final ImmutableMap<String, String> subgroupMap(ImmutableMap<String, String> map, String groupName) {
        return Util.prefixedSubmap(map, groupName + ".");
    }

    private static List<String> getArgs(Map<String, String> properties) {
        return ImmutableList.copyOf((Iterable)ARGS_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)properties.get("args"))));
    }

    private static File getJdkHomeDir(@Nullable String baseDirectoryPath, @Nullable String homeDirPath, String vmConfigName) throws InvalidConfigurationException {
        if (homeDirPath == null) {
            File baseDirectory = CaliperConfig.getBaseDirectory(baseDirectoryPath);
            File homeDir = new File(baseDirectory, vmConfigName);
            CaliperConfig.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", homeDir);
            return homeDir;
        }
        File potentialHomeDir = new File(homeDirPath);
        if (potentialHomeDir.isAbsolute()) {
            CaliperConfig.checkConfiguration(potentialHomeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
            return potentialHomeDir;
        }
        File baseDirectory = CaliperConfig.getBaseDirectory(baseDirectoryPath);
        File homeDir = new File(baseDirectory, homeDirPath);
        CaliperConfig.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
        return homeDir;
    }

    private static File getBaseDirectory(@Nullable String baseDirectoryPath) throws InvalidConfigurationException {
        if (baseDirectoryPath == null) {
            throw new InvalidConfigurationException("must set either a home directory or a base directory");
        }
        File baseDirectory = new File(baseDirectoryPath);
        CaliperConfig.checkConfiguration(baseDirectory.isAbsolute(), "base directory cannot be a relative path");
        CaliperConfig.checkConfiguration(baseDirectory.isDirectory(), "base directory must be a directory");
        return baseDirectory;
    }

    private static void checkConfiguration(boolean check, String message) throws InvalidConfigurationException {
        if (!check) {
            throw new InvalidConfigurationException(message);
        }
    }

    private static void checkConfiguration(boolean check, String messageFormat, Object ... args) throws InvalidConfigurationException {
        if (!check) {
            throw new InvalidConfigurationException(String.format(messageFormat, args));
        }
    }
}

