/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.Host;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.VmSpec;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import org.hibernate.annotations.Immutable;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
@NamedQuery(name="listScenariosForHash", query="SELECT s FROM Scenario s WHERE hash = :hash", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})
public final class Scenario {
    static final Scenario DEFAULT = new Scenario();
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @ManyToOne(optional=false)
    private Host host;
    @ManyToOne(optional=false)
    private VmSpec vmSpec;
    @ManyToOne(optional=false)
    private BenchmarkSpec benchmarkSpec;
    @ExcludeFromJson
    private int hash;

    private Scenario() {
        this.host = Host.DEFAULT;
        this.vmSpec = VmSpec.DEFAULT;
        this.benchmarkSpec = BenchmarkSpec.DEFAULT;
        this.hash = 0;
    }

    private Scenario(Builder builder) {
        this.host = builder.host;
        this.vmSpec = builder.vmSpec;
        this.benchmarkSpec = builder.benchmarkSpec;
        this.hash = PersistentHashing.getPersistentHashFunction().newHasher().putObject((Object)this.host, (Funnel)Host.HostFunnel.INSTANCE).putObject((Object)this.vmSpec, (Funnel)VmSpec.VmSpecFunnel.INSTANCE).putObject((Object)this.benchmarkSpec, (Funnel)BenchmarkSpec.BenchmarkSpecFunnel.INSTANCE).hash().asInt();
    }

    public Host host() {
        return this.host;
    }

    public VmSpec vmSpec() {
        return this.vmSpec;
    }

    public BenchmarkSpec benchmarkSpec() {
        return this.benchmarkSpec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Scenario) {
            Scenario that = (Scenario)obj;
            return this.hash == that.hash && this.host.equals(that.host) && this.vmSpec.equals(that.vmSpec) && this.benchmarkSpec.equals(that.benchmarkSpec);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("environment", (Object)this.host).add("vmSpec", (Object)this.vmSpec).add("benchmarkSpec", (Object)this.benchmarkSpec).toString();
    }

    public static final class Builder {
        private Host host;
        private VmSpec vmSpec;
        private BenchmarkSpec benchmarkSpec;

        public Builder host(Host.Builder hostBuilder) {
            return this.host(hostBuilder.build());
        }

        public Builder host(Host host) {
            this.host = (Host)Preconditions.checkNotNull((Object)host);
            return this;
        }

        public Builder vmSpec(VmSpec.Builder vmSpecBuilder) {
            return this.vmSpec(vmSpecBuilder.build());
        }

        public Builder vmSpec(VmSpec vmSpec) {
            this.vmSpec = (VmSpec)Preconditions.checkNotNull((Object)vmSpec);
            return this;
        }

        public Builder benchmarkSpec(BenchmarkSpec.Builder benchmarkSpecBuilder) {
            return this.benchmarkSpec(benchmarkSpecBuilder.build());
        }

        public Builder benchmarkSpec(BenchmarkSpec benchmarkSpec) {
            this.benchmarkSpec = (BenchmarkSpec)Preconditions.checkNotNull((Object)benchmarkSpec);
            return this;
        }

        public Scenario build() {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0);
            Preconditions.checkState((this.vmSpec != null ? 1 : 0) != 0);
            Preconditions.checkState((this.benchmarkSpec != null ? 1 : 0) != 0);
            return new Scenario(this);
        }
    }
}

