/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.api.VmOptions;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.Parameter;
import com.google.caliper.runner.ParameterSet;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.InvalidCommandException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.Map;

public final class BenchmarkClass {
    private final Class<? extends Benchmark> theClass;
    private final Constructor<? extends Benchmark> constructor;
    private final ParameterSet userParameters;
    private final ImmutableSet<String> benchmarkFlags;
    private static final Method SETUP_METHOD = BenchmarkClass.findBenchmarkMethod("setUp");
    private static final Method TEARDOWN_METHOD = BenchmarkClass.findBenchmarkMethod("tearDown");

    public BenchmarkClass(Class<?> aClass) throws InvalidBenchmarkException {
        if (Modifier.isAbstract(aClass.getModifiers())) {
            throw new InvalidBenchmarkException("Class '%s' is abstract", aClass);
        }
        try {
            this.theClass = aClass.asSubclass(Benchmark.class);
        }
        catch (ClassCastException e) {
            throw new InvalidBenchmarkException("Class '%s' does not extend %s", aClass, Benchmark.class.getName());
        }
        this.constructor = BenchmarkClass.findConstructor(this.theClass);
        this.userParameters = ParameterSet.create(this.theClass, Param.class);
        this.benchmarkFlags = BenchmarkClass.getVmOptions(this.theClass);
    }

    public ParameterSet userParameters() {
        return this.userParameters;
    }

    public ImmutableSet<String> vmOptions() {
        return this.benchmarkFlags;
    }

    public ImmutableSortedSet<BenchmarkMethod> findAllBenchmarkMethods(Instrument instrument) throws InvalidBenchmarkException {
        ImmutableSortedSet.Builder result = ImmutableSortedSet.orderedBy((Comparator)Ordering.natural().onResultOf((Function)new Function<BenchmarkMethod, String>(){

            public String apply(BenchmarkMethod method) {
                return method.name();
            }
        }));
        for (Method method : this.theClass.getDeclaredMethods()) {
            if (!instrument.isBenchmarkMethod(method)) continue;
            result.add((Object)instrument.createBenchmarkMethod(this, method));
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Benchmark createAndStage(ImmutableSortedMap<String, String> userParameterValues) throws UserCodeException {
        Benchmark benchmark = BenchmarkClass.createBenchmarkInstance(this.constructor);
        this.userParameters.injectAll(benchmark, (Map<String, String>)userParameterValues);
        boolean setupSuccess = false;
        try {
            this.callSetUp(benchmark);
            setupSuccess = true;
        }
        finally {
            if (!setupSuccess) {
                this.callTearDown(benchmark);
            }
        }
        return benchmark;
    }

    public void cleanup(Benchmark benchmark) throws UserCodeException {
        this.callTearDown(benchmark);
    }

    @VisibleForTesting
    Class<? extends Benchmark> benchmarkClass() {
        return this.theClass;
    }

    public String name() {
        return this.theClass.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BenchmarkClass) {
            BenchmarkClass that = (BenchmarkClass)obj;
            return this.theClass.equals(that.theClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.theClass});
    }

    public String toString() {
        return this.name();
    }

    private void callSetUp(Benchmark benchmark) throws UserCodeException {
        try {
            SETUP_METHOD.invoke((Object)benchmark, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), SkipThisScenarioException.class);
            throw new UserCodeException("Exception thrown during setUp", e.getCause());
        }
    }

    private void callTearDown(Benchmark benchmark) throws UserCodeException {
        try {
            TEARDOWN_METHOD.invoke((Object)benchmark, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new UserCodeException("Exception thrown during tearDown", e.getCause());
        }
    }

    private static Method findBenchmarkMethod(String methodName) {
        try {
            Method method = Benchmark.class.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Constructor<? extends Benchmark> findConstructor(Class<? extends Benchmark> theClass) throws InvalidBenchmarkException {
        Constructor<? extends Benchmark> constructor;
        try {
            constructor = theClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidBenchmarkException("Class '%s' has no parameterless constructor", theClass);
        }
        constructor.setAccessible(true);
        return constructor;
    }

    private static ImmutableSet<String> getVmOptions(Class<? extends Benchmark> benchmarkClass) {
        VmOptions annotation = benchmarkClass.getAnnotation(VmOptions.class);
        return annotation == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])annotation.value());
    }

    private static Benchmark createBenchmarkInstance(Constructor<? extends Benchmark> c) throws UserCodeException {
        try {
            return c.newInstance(new Object[0]);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InstantiationException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            throw new UserCodeException("Exception thrown from benchmark constructor", e.getCause());
        }
    }

    void validateParameters(ImmutableSetMultimap<String, String> parameters) throws InvalidCommandException {
        for (String paramName : parameters.keySet()) {
            Parameter parameter = this.userParameters.get(paramName);
            if (parameter == null) {
                throw new InvalidCommandException("unrecognized parameter: " + paramName, new Object[0]);
            }
            try {
                parameter.validate((ImmutableCollection<String>)parameters.get((Object)paramName));
            }
            catch (InvalidBenchmarkException e) {
                throw new InvalidCommandException(e.getMessage(), new Object[0]);
            }
        }
    }
}

