/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.model.VmSpec;
import com.google.caliper.util.Stdout;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.util.Set;

final class ConsoleResultProcessor
implements ResultProcessor {
    private final PrintWriter stdout;
    private Set<InstrumentSpec> instrumentSpecs = Sets.newHashSet();
    private Set<VmSpec> vmSpecs = Sets.newHashSet();
    private Set<BenchmarkSpec> benchmarkSpecs = Sets.newHashSet();
    private int numMeasurements = 0;

    @Inject
    ConsoleResultProcessor(@Stdout PrintWriter stdout) {
        this.stdout = stdout;
    }

    @Override
    public void processTrial(Trial trial) {
        this.instrumentSpecs.add(trial.instrumentSpec());
        Scenario scenario = trial.scenario();
        this.vmSpecs.add(scenario.vmSpec());
        this.benchmarkSpecs.add(scenario.benchmarkSpec());
        this.numMeasurements += trial.measurements().size();
    }

    @Override
    public void close() {
        this.stdout.printf("Collected %d measurements from:%n", this.numMeasurements);
        this.stdout.printf("  %d instrument(s)%n", this.instrumentSpecs.size());
        this.stdout.printf("  %d virtual machine(s)%n", this.vmSpecs.size());
        this.stdout.printf("  %d benchmark(s)%n", this.benchmarkSpecs.size());
        this.stdout.flush();
    }
}

