/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.caliper.util.Parser;
import com.google.caliper.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.List;

public class Parsers {
    public static final Parser<String> IDENTITY = new Parser<String>(){

        @Override
        public String parse(CharSequence in) {
            return in.toString();
        }
    };
    private static final List<String> CONVERSION_METHOD_NAMES = ImmutableList.of((Object)"fromString", (Object)"decode", (Object)"valueOf");

    public static <T> Parser<T> conventionalParser(Class<T> resultType) throws NoSuchMethodException {
        if (resultType == String.class) {
            Parser<String> identity = IDENTITY;
            return identity;
        }
        final Class wrappedResultType = Primitives.wrap(resultType);
        for (String methodName : CONVERSION_METHOD_NAMES) {
            try {
                final Method method = wrappedResultType.getDeclaredMethod(methodName, String.class);
                if (!Util.isStatic(method) || !wrappedResultType.isAssignableFrom(method.getReturnType())) continue;
                method.setAccessible(true);
                return new InvokingParser<T>(){

                    @Override
                    protected T invoke(String input) throws Exception {
                        return wrappedResultType.cast(method.invoke(null, input));
                    }
                };
            }
            catch (Exception tryAgain) {
            }
        }
        final Constructor constr = wrappedResultType.getDeclaredConstructor(String.class);
        constr.setAccessible(true);
        return new InvokingParser<T>(){

            @Override
            protected T invoke(String input) throws Exception {
                return wrappedResultType.cast(constr.newInstance(input));
            }
        };
    }

    public static ParseException newParseException(String message, Throwable cause) {
        ParseException pe = Parsers.newParseException(message);
        pe.initCause(cause);
        return pe;
    }

    public static ParseException newParseException(String message) {
        return new ParseException(message, 0);
    }

    private static <T> T firstNonNull(T first, T second) {
        return first != null ? first : second;
    }

    static abstract class InvokingParser<T>
    implements Parser<T> {
        InvokingParser() {
        }

        @Override
        public T parse(CharSequence input) throws ParseException {
            try {
                return this.invoke(input.toString());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String desc = (String)Parsers.firstNonNull(cause.getMessage(), cause.getClass().getSimpleName());
                throw Parsers.newParseException(desc, cause);
            }
            catch (Exception e) {
                throw Parsers.newParseException("Unknown parsing problem", e);
            }
        }

        protected abstract T invoke(String var1) throws Exception;
    }
}

