/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import java.lang.reflect.Method;
import java.util.Map;

public final class ArbitraryMeasurementWorker
implements Worker {
    @Override
    public void measure(Benchmark benchmark, String methodName, Map<String, String> optionsMap, WorkerEventLog log) throws Exception {
        Options options = new Options(optionsMap);
        Method method = benchmark.getClass().getDeclaredMethod(methodName, new Class[0]);
        ArbitraryMeasurement annotation = method.getAnnotation(ArbitraryMeasurement.class);
        String unit = annotation.units();
        String description = annotation.description();
        log.notifyMeasurementPhaseStarting();
        if (options.gcBeforeEach) {
            Util.forceGc();
        }
        log.notifyMeasurementStarting();
        double measured = (Double)method.invoke((Object)benchmark, new Object[0]);
        log.notifyMeasurementEnding(new Measurement.Builder().value(Value.create(measured, unit)).weight(1.0).description(description).build());
    }

    private static class Options {
        final boolean gcBeforeEach;

        Options(Map<String, String> options) {
            this.gcBeforeEach = Boolean.parseBoolean(options.get("gcBeforeEach"));
        }
    }
}

