/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.util.Reflection;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class MacrobenchmarkWorker
implements Worker {
    private final Stopwatch stopwatch;

    @Inject
    MacrobenchmarkWorker(Random random, Ticker ticker) {
        this.stopwatch = new Stopwatch(ticker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void measure(Benchmark benchmark, String methodName, Map<String, String> optionMap, WorkerEventLog log) throws Exception {
        method = benchmark.getClass().getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        beforeRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), BeforeRep.class);
        afterRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), AfterRep.class);
        log.notifyMeasurementPhaseStarting();
        while (true) lbl-1000:
        // 4 sources

        {
            for (Method beforeRepMethod : beforeRepMethods) {
                beforeRepMethod.invoke((Object)benchmark, new Object[0]);
            }
            log.notifyMeasurementStarting();
            try {
                this.stopwatch.start();
                method.invoke((Object)benchmark, new Object[0]);
                nanos = this.stopwatch.stop().elapsed(TimeUnit.NANOSECONDS);
                this.stopwatch.reset();
                log.notifyMeasurementEnding(new Measurement.Builder().description("runtime").weight(1.0).value(Value.create(nanos, "ns")).build());
                ** continue;
            }
            finally {
                for (Method afterRepMethod : afterRepMethods) {
                    afterRepMethod.invoke((Object)benchmark, new Object[0]);
                }
                continue;
            }
            break;
        }
    }
}

