/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.caliper.worker.Worker;
import com.google.common.base.Charsets;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.MembersInjector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.ParseException;

final class WorkerModule
extends AbstractModule {
    private final Class<? extends Benchmark> benchmarkClass;
    private final Class<? extends Worker> workerClass;
    private final ImmutableMap<String, String> parameters;
    private final String pipePath;

    WorkerModule(WorkerSpec workerSpec) {
        try {
            this.workerClass = Class.forName(workerSpec.workerClassName);
            this.benchmarkClass = Class.forName(workerSpec.benchmarkSpec.className());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"classes referenced in the runner are always present");
        }
        this.parameters = ImmutableMap.copyOf(workerSpec.benchmarkSpec.parameters());
        this.pipePath = workerSpec.pipePath;
    }

    protected void configure() {
        this.bind(this.benchmarkClass);
        this.bind(Benchmark.class).to(this.benchmarkClass);
        this.bind(Worker.class).to(this.workerClass);
        this.bind(Ticker.class).toInstance((Object)Ticker.systemTicker());
        this.bindListener((Matcher)new BenchmarkTypeMatcher(), new BenchmarkParameterInjector());
    }

    @Provides
    @Singleton
    PrintWriter providePrintWriter() throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.pipePath)), Charsets.UTF_8), true);
        printWriter.println();
        printWriter.flush();
        return printWriter;
    }

    private final class BenchmarkParameterInjector
    implements TypeListener {
        private BenchmarkParameterInjector() {
        }

        public <I> void hear(TypeLiteral<I> type, final TypeEncounter<I> encounter) {
            for (final Field field : type.getRawType().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Param.class)) continue;
                encounter.register(new MembersInjector<I>(){

                    public void injectMembers(I instance) {
                        try {
                            field.setAccessible(true);
                            Parser<?> parser = Parsers.conventionalParser(field.getType());
                            field.set(instance, parser.parse((CharSequence)WorkerModule.this.parameters.get((Object)field.getName())));
                        }
                        catch (NoSuchMethodException e) {
                            encounter.addError((Throwable)e);
                        }
                        catch (ParseException e) {
                            encounter.addError((Throwable)e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new AssertionError((Object)"types have been checked");
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)"already set access");
                        }
                    }
                });
            }
        }
    }

    private static final class BenchmarkTypeMatcher
    extends AbstractMatcher<TypeLiteral<?>> {
        private BenchmarkTypeMatcher() {
        }

        public boolean matches(TypeLiteral<?> t) {
            return Benchmark.class.isAssignableFrom(t.getRawType());
        }
    }
}

