/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.com.google.common.collect;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Preconditions;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ImmutableAsList;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ImmutableList;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.RegularImmutableList;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.RegularImmutableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableSortedAsList<E>
extends RegularImmutableList<E> {
    private final transient ImmutableSortedSet<E> set;

    ImmutableSortedAsList(Object[] array, int offset, int size, ImmutableSortedSet<E> set) {
        super(array, offset, size);
        this.set = set;
    }

    @Override
    public boolean contains(Object target) {
        return this.set.indexOf(target) >= 0;
    }

    @Override
    public int indexOf(Object target) {
        return this.set.indexOf(target);
    }

    @Override
    public int lastIndexOf(Object target) {
        return this.set.indexOf(target);
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        return fromIndex == toIndex ? ImmutableList.of() : new RegularImmutableSortedSet<E>(this.array(), this.set.comparator(), this.offset() + fromIndex, this.offset() + toIndex).asList();
    }

    @Override
    Object writeReplace() {
        return new ImmutableAsList.SerializedForm(this.set);
    }
}

