/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameAwarePurgableFileInputStream
extends FileInputStream {
    private static final Logger log = LoggerFactory.getLogger(NameAwarePurgableFileInputStream.class);
    private final File file;
    private final boolean purgeFileOnClose;

    public NameAwarePurgableFileInputStream(File file, boolean purgeFileOnClose) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.purgeFileOnClose = purgeFileOnClose;
    }

    public NameAwarePurgableFileInputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.purgeFileOnClose && this.file.exists() && !this.file.delete()) {
            log.warn("Failed to purge file: " + this.file.getAbsolutePath());
        }
    }
}

