/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.scheduler.NonBlocking;

public class NettyBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
        builder.allowBlockingCallsInside(ChannelInitializer.class.getName(), "initChannel");
        builder.allowBlockingCallsInside(GlobalEventExecutor.class.getName(), "addTask");
        builder.allowBlockingCallsInside(SingleThreadEventExecutor.class.getName(), "confirmShutdown");
        builder.disallowBlockingCallsInside(AbstractEventExecutor.class.getName(), "safeExecute");
        builder.disallowBlockingCallsInside(SingleThreadEventExecutor.class.getName() + "$5", "run");
    }
}

