<?php
session_start()
?>

@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    <script src="/js/3.1.1/jquery.min.js"></script>
<script src="/js/jquery.validate.min.js"></script>
{{--    引入bootstrap-table css樣式與js--}}
    <link href="https://unpkg.com/bootstrap-table@1.18.3/dist/extensions/group-by-v2/bootstrap-table-group-by.css" rel="stylesheet">
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
    <script src="https://unpkg.com/bootstrap-table@1.18.3/dist/extensions/group-by-v2/bootstrap-table-group-by.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        .seeline{
            border: #000000 1px solid;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .error {
            color: #66A8CC;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '26'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-10" style="background:#e0e6ec">
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%;text-align: center">
                    {{--操作列--}}
                        <form class="row" id="attendance_setting_from" method="post" action="{{ Route('shift_punch_card_export') }}" style="height: 10vh">
                            {{ csrf_field() }}
                            <div class="col-3">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">起始時間</div>
                                    </div>
                                    <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div  class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">結束時間</div>
                                    </div>
                                    <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                    <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <button type="submit" class="btn btn-outline-dark" style="margin-right: 10px;float: left">匯出</button>
                            </div>
                            <div class="col-3 float-right">
                                <button type="button" class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#Shift">班別編修</button>
                            </div>
                        </form>
                    <p></p>
                    {{--表格呈現-列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}


    {{-- 班別編修彈出視窗 --}}
    <div class="modal fade " id="Shift" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content" style="height: 600px">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">班別編修</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    <div class="modal-body row">
                        <input type="hidden" class="form-control" id="features_user" name="features_user" readonly>
                        <div class="col-12 text-center" style="height: 420px; overflow: auto">

                            <table class="table table-striped table-bordered table-hover" id="tableL02">
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td><input type="text" id="i_name" class="form-control" placeholder="" required></td>
                                        <td><input type="time" id="i_start" class="form-control" placeholder="" required></td>
                                        <td><input type="time" id="i_end" class="form-control" placeholder="" required></td>
                                        <td><input type="text" id="i_note" class="form-control" placeholder="" required></td>
                                        <td>
                                            <button type="button" class="btn btn-outline-success" onclick="insert_shift()">新增</button>
                                        </td>
                                    </tr>
                                @foreach($shifts as $shift)
                                    <tr>
                                        <td>{{$shift["no"]}}</td>
                                        <td>
                                            <a id="a_{{$shift["no"]}}_name" style="display: inline; cursor: pointer;" onclick="change_update('{{$shift["no"]}}')">{{$shift["name"]}}</a>
                                            <input type="hidden" class="form-control" id="u_{{$shift["no"]}}_name" value="{{$shift["name"]}}" required>
                                        </td>
                                        <td>
                                            <a id="a_{{$shift["no"]}}_start" style="display: inline; cursor: pointer;" onclick="change_update('{{$shift["no"]}}')">{{$shift["start"]}}</a>
                                            <input type="hidden" class="form-control" id="u_{{$shift["no"]}}_start" value="{{$shift["start"]}}" required>
                                        </td>
                                        <td>
                                            <a id="a_{{$shift["no"]}}_end" style="display: inline; cursor: pointer;" onclick="change_update('{{$shift["no"]}}')">{{$shift["end"]}}</a>
                                            <input type="hidden" class="form-control" id="u_{{$shift["no"]}}_end" value="{{$shift["end"]}}" required>
                                        </td>
                                        <td>
                                            <a id="a_{{$shift["no"]}}_note" style="display: inline; cursor: pointer;" onclick="change_update('{{$shift["no"]}}')">{{$shift["note"]}}</a>
                                            <input type="hidden" class="form-control" id="u_{{$shift["no"]}}_note" value="{{$shift["note"]}}" required>
                                        </td>
                                        <td>
                                            <button type="button" id="btn_{{$shift["no"]}}_change" class="btn btn-outline-info" style="display: inline" onclick="change_update('{{$shift["no"]}}')">修改</button>
                                            <button type="button" id="btn_{{$shift["no"]}}_update" class="btn btn-outline-info" style="display: none" onclick="update_shift('{{$shift["no"]}}')">送出</button>
                                            <button type="button" class="btn btn-outline-danger" onclick="delete_shift('{{$shift["no"]}}')">刪除</button>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" >
                        <button type="button" class="btn btn-primary" data-dismiss="modal">確定</button>
                    </div>
            </div>
        </div>
        <div>
        </div>
    </div>

    {{-- 班別編修彈出視窗 --}}
    <div class="modal fade" id="DeviceShift" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content" style="height: 600px">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">班別編修</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="device_shift_relation" action="{{ route("device_shift_update") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12 text-center" style="height: 420px; overflow: auto">
                            <input type="hidden" class="form-control" id="device_id" name="device_id" readonly>
                            <table class="table table-striped table-bordered table-hover" id="tableL03">
                                <tbody>
                                @foreach($shifts as $shift)
                                    <tr>
                                        <td>
                                            <input id="shift_{{$shift["name"]}}" type="checkbox" name="device_shift_{{$shift["no"]}}" value="{{$shift["no"]}}"/>
                                        </td>
                                        <td>
                                            <a>{{$shift["name"]}}</a>
                                        </td>
                                        <td>
                                            <a>{{$shift["start"]}}</a>
                                        </td>
                                        <td>
                                            <a>{{$shift["end"]}}</a>
                                        </td>
                                        <td>
                                            <a>{{$shift["note"]}}</a>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer" >
                        <button type="submit" class="btn btn-primary">確定</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    </div>
                </form>
            </div>
        </div>
        <div>
        </div>
    </div>

<script>
    function change_update(no)
    {
        var name_id="u_"+no+"_name";
        document.getElementById(name_id).type="text";
        var start_id="u_"+no+"_start";
        document.getElementById(start_id).type="time";
        var end_id="u_"+no+"_end";
        document.getElementById(end_id).type="time";
        var note_id="u_"+no+"_note";
        document.getElementById(note_id).type="text";

        var name_a="a_"+no+"_name";
        document.getElementById(name_a).style.display="none";
        var start_a="a_"+no+"_start";
        document.getElementById(start_a).style.display="none";
        var end_a="a_"+no+"_end";
        document.getElementById(end_a).style.display="none";
        var note_a="a_"+no+"_note";
        document.getElementById(note_a).style.display="none";

        var change_id="btn_"+no+"_change";
        var update_id="btn_"+no+"_update";
        document.getElementById(update_id).style.display="inline";
        document.getElementById(change_id).style.display="none";
    }
    function insert_shift()
    {
        var name = document.getElementById("i_name").value;
        var start = document.getElementById("i_start").value;
        var end = document.getElementById("i_end").value;
        var note = document.getElementById("i_note").value;
        var form=document.createElement("form");
        form.setAttribute("method","post");
        form.setAttribute("action","{{Route("shift_insert")}}");
        var input_name = document.createElement("input");
        input_name.setAttribute("type", "hidden");
        input_name.setAttribute("name", "name");
        input_name.setAttribute("value",name);
        form.appendChild(input_name);
        var input_start = document.createElement("input");
        input_start.setAttribute("type", "hidden");
        input_start.setAttribute("name", "start");
        input_start.setAttribute("value",start);
        form.appendChild(input_start);
        var input_end = document.createElement("input");
        input_end.setAttribute("type", "hidden");
        input_end.setAttribute("name", "end");
        input_end.setAttribute("value",end);
        form.appendChild(input_end);
        var input_note = document.createElement("input");
        input_note.setAttribute("type", "hidden");
        input_note.setAttribute("name", "note");
        input_note.setAttribute("value",note);
        form.appendChild(input_note);
        var csrfField=document.createElement("input");
        csrfField.setAttribute("type", "hidden");
        csrfField.setAttribute("name", "_token");
        csrfField.setAttribute("value", "{{ csrf_token() }}");
        form.appendChild(csrfField);
        document.body.appendChild(form);
        form.submit();
    }
    function update_shift(no)
    {
        var name_id="u_"+no+"_name";
        var name = document.getElementById(name_id).value;
        var start_id="u_"+no+"_start";
        var start = document.getElementById(start_id).value;
        var end_id="u_"+no+"_end";
        var end = document.getElementById(end_id).value;
        var note_id="u_"+no+"_note";
        var note = document.getElementById(note_id).value;
        var form=document.createElement("form");
        form.setAttribute("method","post");
        form.setAttribute("action","{{Route("shift_update")}}");
        var input_no = document.createElement("input");
        input_no.setAttribute("type", "hidden");
        input_no.setAttribute("name", "no");
        input_no.setAttribute("value",no);
        form.appendChild(input_no);
        var input_name = document.createElement("input");
        input_name.setAttribute("type", "hidden");
        input_name.setAttribute("name", "name");
        input_name.setAttribute("value",name);
        form.appendChild(input_name);
        var input_start = document.createElement("input");
        input_start.setAttribute("type", "hidden");
        input_start.setAttribute("name", "start");
        input_start.setAttribute("value",start);
        form.appendChild(input_start);
        var input_end = document.createElement("input");
        input_end.setAttribute("type", "hidden");
        input_end.setAttribute("name", "end");
        input_end.setAttribute("value",end);
        form.appendChild(input_end);
        var input_note = document.createElement("input");
        input_note.setAttribute("type", "hidden");
        input_note.setAttribute("name", "note");
        input_note.setAttribute("value",note);
        form.appendChild(input_note);
        var csrfField=document.createElement("input");
        csrfField.setAttribute("type", "hidden");
        csrfField.setAttribute("name", "_token");
        csrfField.setAttribute("value", "{{ csrf_token() }}");
        form.appendChild(csrfField);
        document.body.appendChild(form);
        form.submit();
    }
    function delete_shift(no)
    {
        var form=document.createElement("form");
        form.setAttribute("method","post");
        form.setAttribute("action","{{Route("shift_delete")}}");
        var input_no = document.createElement("input");
        input_no.setAttribute("type", "hidden");
        input_no.setAttribute("name", "no");
        input_no.setAttribute("value",no);
        form.appendChild(input_no);
        var csrfField=document.createElement("input");
        csrfField.setAttribute("type", "hidden");
        csrfField.setAttribute("name", "_token");
        csrfField.setAttribute("value", "{{ csrf_token() }}");
        form.appendChild(csrfField);
        document.body.appendChild(form);
        form.submit();
    }

    //device_shift_relation
    function device_shift_data(obj)
    {
        @foreach($shifts as $shift)
            var name = "shift_"+"{{$shift["name"]}}"
            document.getElementById(name).checked=false;
        @endforeach
        let jdata_index = parseInt(obj.closest('tr').getAttribute("data-index"));
        document.getElementById("device_id").value=jdata[jdata_index].id;
        var shift_list = jdata[jdata_index].shift_list;
        var shift_array = shift_list.split(",");
        for(var i=0;i<shift_array.length;i++)
        {
            if(shift_array[i]!="")
            {
                document.getElementById("shift_"+shift_array[i]).checked=true;
            }
        }
    }


</script>




{{--    boostrap tabel js--}}
    <script>
        // 載入人員資料
        @php
            if(isset($devices)){
                echo "var jdata=".json_encode($devices).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷燬表格
        var tableColumns = [
            // {field: 'state', checkbox: true,},
            // {field: 'no',title: '編號',sortable: true},
            {field: 'id', title: '設備編號', sortable: true},
            {field: 'location', title: '設備位置', sortable: true},
            {field: 'shift_list', title: '班別', sortable: true},

            {field: 'modify', title: '', sortable: false},
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'location', // 預設排序
            groupBy:false,
            groupByField:'group'
        });

        var tableColumns2 = [
            {field: 'no',title: '編號',sortable: false},
            {field: 'name', title: '班別', sortable: false,width:80},
            {field: 'start', title: '開始時間', sortable: false,width:170},
            {field: 'end', title: '結束時間', sortable: false,width:170},
            {field: 'note', title: '備註', sortable: false,width:100},
            {field: '', title: '', sortable: false},
        ];
        $('#tableL02').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns2,  //表頭
            // width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            //height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'no', // 預設排序
        });

        var tableColumns3 = [
            //{field: 'no',title: '編號',sortable: false,},
            {field: '', title: '', sortable: false,width:50},
            {field: 'name', title: '班別', sortable: false},
            {field: 'start', title: '開始時間', sortable: false},
            {field: 'end', title: '結束時間', sortable: false},
            {field: 'note', title: '備註', sortable: false},

        ];
        $('#tableL03').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns3,  //表頭
            // width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            // height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'name', // 預設排序
        });

    </script>
    <!-- 上班時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date().setHours(23,59,59),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y-m-d")." 00:00:00") }}"), // 初始值
            });
        });
    </script>
    <!-- 下班時間 (datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date().setHours(23,59,59),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{old('end_time',date("Y-m-d")." 23:59:59") }}") // 初始值
            });
        });
    </script>


@endsection
