/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import com.google.caliper.Param;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.runner.CaliperMain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.benchmarks.Client;
import okhttp3.benchmarks.HttpClient;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;
import okio.Buffer;
import okio.GzipSink;
import okio.Sink;

public class Benchmark
extends com.google.caliper.Benchmark {
    private static final int NUM_REPORTS = 10;
    private static final boolean VERBOSE = false;
    private final Random random = new Random(0L);
    @Param
    Client client;
    @Param(value={"1", "10"})
    int concurrencyLevel;
    @Param(value={"10"})
    int targetBacklog;
    @Param
    boolean tls;
    @Param
    boolean gzip;
    @Param
    boolean chunked;
    @Param(value={"128", "1048576"})
    int bodyByteCount;
    @Param(value={"0", "20"})
    int headerCount;
    List<Protocol> protocols = Arrays.asList(Protocol.HTTP_1_1);

    public static void main(String[] args) {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add("--instrument");
        allArgs.add("arbitrary");
        allArgs.addAll(Arrays.asList(args));
        CaliperMain.main(Benchmark.class, (String[])allArgs.toArray(new String[allArgs.size()]));
    }

    @ArbitraryMeasurement(description="requests per second")
    public double run() throws Exception {
        HttpClient httpClient = this.client.create();
        httpClient.prepare(this);
        MockWebServer server = this.startServer();
        HttpUrl url = server.url("/");
        int requestCount = 0;
        long reportStart = System.nanoTime();
        long reportPeriod = TimeUnit.SECONDS.toNanos(1L);
        int reports = 0;
        double best = 0.0;
        while (reports < 10) {
            long now = System.nanoTime();
            double reportDuration = now - reportStart;
            if (reportDuration > (double)reportPeriod) {
                double requestsPerSecond = (double)requestCount / reportDuration * (double)TimeUnit.SECONDS.toNanos(1L);
                best = Math.max(best, requestsPerSecond);
                requestCount = 0;
                reportStart = now;
                ++reports;
            }
            while (httpClient.acceptingJobs()) {
                httpClient.enqueue(url);
                ++requestCount;
            }
            this.sleep(1);
        }
        return best;
    }

    public String toString() {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.tls) {
            modifiers.add("tls");
        }
        if (this.gzip) {
            modifiers.add("gzip");
        }
        if (this.chunked) {
            modifiers.add("chunked");
        }
        modifiers.addAll(this.protocols);
        return String.format("%s %s\nbodyByteCount=%s headerCount=%s concurrencyLevel=%s", new Object[]{this.client, modifiers, this.bodyByteCount, this.headerCount, this.concurrencyLevel});
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private MockWebServer startServer() throws IOException {
        Logger.getLogger(MockWebServer.class.getName()).setLevel(Level.WARNING);
        MockWebServer server = new MockWebServer();
        if (this.tls) {
            HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
            server.useHttps(handshakeCertificates.sslSocketFactory(), false);
            server.setProtocols(this.protocols);
        }
        final MockResponse response = this.newResponse();
        server.setDispatcher(new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) {
                return response;
            }
        });
        server.start();
        return server;
    }

    private MockResponse newResponse() throws IOException {
        byte[] bytes = new byte[this.bodyByteCount];
        this.random.nextBytes(bytes);
        Buffer body = new Buffer().write(bytes);
        MockResponse result = new MockResponse();
        if (this.gzip) {
            Buffer gzipBody = new Buffer();
            GzipSink gzipSink = new GzipSink((Sink)gzipBody);
            gzipSink.write(body, body.size());
            gzipSink.close();
            body = gzipBody;
            result.addHeader("Content-Encoding: gzip");
        }
        if (this.chunked) {
            result.setChunkedBody(body, 1024);
        } else {
            result.setBody(body);
        }
        for (int i = 0; i < this.headerCount; ++i) {
            result.addHeader(this.randomString(12), (Object)this.randomString(20));
        }
        return result;
    }

    private String randomString(int length) {
        String alphabet = "-abcdefghijklmnopqrstuvwxyz";
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = alphabet.charAt(this.random.nextInt(alphabet.length()));
        }
        return new String(result);
    }
}

