/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.net.ssl.SSLEngine;
import okhttp3.HttpUrl;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.HttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;

class NettyHttpClient
implements HttpClient {
    private static final boolean VERBOSE = false;
    private final Deque<HttpChannel> freeChannels = new ArrayDeque<HttpChannel>();
    private final Deque<HttpUrl> backlog = new ArrayDeque<HttpUrl>();
    private int totalChannels = 0;
    private int concurrencyLevel;
    private int targetBacklog;
    private Bootstrap bootstrap;

    NettyHttpClient() {
    }

    @Override
    public void prepare(final Benchmark benchmark) {
        this.concurrencyLevel = benchmark.concurrencyLevel;
        this.targetBacklog = benchmark.targetBacklog;
        ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                if (benchmark.tls) {
                    HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
                    SSLEngine engine = handshakeCertificates.sslContext().createSSLEngine();
                    engine.setUseClientMode(true);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                pipeline.addLast("handler", (ChannelHandler)new HttpChannel(channel));
            }
        };
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.concurrencyLevel))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).channel(NioSocketChannel.class)).handler((ChannelHandler)channelInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(HttpUrl url) throws Exception {
        HttpChannel httpChannel = null;
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (!this.freeChannels.isEmpty()) {
                httpChannel = this.freeChannels.pop();
            } else if (this.totalChannels < this.concurrencyLevel) {
                ++this.totalChannels;
            } else {
                this.backlog.add(url);
                return;
            }
        }
        if (httpChannel == null) {
            Channel channel = this.bootstrap.connect(url.host(), url.port()).sync().channel();
            httpChannel = (HttpChannel)channel.pipeline().last();
        }
        httpChannel.sendRequest(url);
    }

    @Override
    public synchronized boolean acceptingJobs() {
        return this.backlog.size() < this.targetBacklog || this.hasFreeChannels();
    }

    private boolean hasFreeChannels() {
        int activeChannels = this.totalChannels - this.freeChannels.size();
        return activeChannels < this.concurrencyLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(HttpChannel httpChannel) {
        HttpUrl url;
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            url = this.backlog.pop();
            if (url == null) {
                this.freeChannels.push(httpChannel);
                return;
            }
        }
        httpChannel.sendRequest(url);
    }

    class HttpChannel
    extends SimpleChannelInboundHandler<HttpObject> {
        private final SocketChannel channel;
        byte[] buffer = new byte[1024];
        int total;
        long start;

        HttpChannel(SocketChannel channel) {
            this.channel = channel;
        }

        private void sendRequest(HttpUrl url) {
            this.start = System.nanoTime();
            this.total = 0;
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, url.encodedPath());
            request.headers().set("Host", (Object)url.host());
            request.headers().set("Accept-Encoding", (Object)"gzip");
            this.channel.writeAndFlush((Object)request);
        }

        protected void channelRead0(ChannelHandlerContext context, HttpObject message) {
            if (message instanceof HttpResponse) {
                this.receive((HttpResponse)message);
            }
            if (message instanceof HttpContent) {
                this.receive((HttpContent)message);
                if (message instanceof LastHttpContent) {
                    NettyHttpClient.this.release(this);
                }
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
        }

        void receive(HttpResponse response) {
        }

        void receive(HttpContent content) {
            int toRead;
            ByteBuf byteBuf = content.content();
            while ((toRead = byteBuf.readableBytes()) > 0) {
                byteBuf.readBytes(this.buffer, 0, Math.min(this.buffer.length, toRead));
                this.total += toRead;
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            System.out.println("Failed: " + cause);
        }
    }
}

