/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.SynchronousHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;

class OkHttp
extends SynchronousHttpClient {
    private static final boolean VERBOSE = false;
    private OkHttpClient client;

    OkHttp() {
    }

    @Override
    public void prepare(Benchmark benchmark) {
        super.prepare(benchmark);
        this.client = new OkHttpClient.Builder().protocols(benchmark.protocols).build();
        if (benchmark.tls) {
            HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
            SSLSocketFactory socketFactory = handshakeCertificates.sslSocketFactory();
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession session) {
                    return true;
                }
            };
            this.client = new OkHttpClient.Builder().sslSocketFactory(socketFactory, handshakeCertificates.trustManager()).hostnameVerifier(hostnameVerifier).build();
        }
    }

    @Override
    public Runnable request(HttpUrl url) {
        Call call = this.client.newCall(new Request.Builder().url(url).build());
        return new OkHttpRequest(call);
    }

    class OkHttpRequest
    implements Runnable {
        private final Call call;

        OkHttpRequest(Call call) {
            this.call = call;
        }

        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                ResponseBody body = this.call.execute().body();
                long total = SynchronousHttpClient.readAllAndClose(body.byteStream());
                long l = System.nanoTime();
            }
            catch (IOException e) {
                System.out.println("Failed: " + e);
            }
        }
    }
}

