/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.util.Internal;

@Internal
final class HSSFEvaluationSheet
implements EvaluationSheet {
    private final HSSFSheet _hs;
    private int _lastDefinedRow = -1;

    public HSSFEvaluationSheet(HSSFSheet hs) {
        this._hs = hs;
        this._lastDefinedRow = this._hs.getLastRowNum();
    }

    public HSSFSheet getHSSFSheet() {
        return this._hs;
    }

    @Override
    public int getLastRowNum() {
        return this._lastDefinedRow;
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        HSSFRow row = this._hs.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new HSSFEvaluationCell(cell, this);
    }

    @Override
    public void clearAllCachedResultValues() {
        this._lastDefinedRow = this._hs.getLastRowNum();
    }
}

