/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class TokenList {
    private TokenList() {
    }

    public static void parseTokenList(Enumeration<String> inputs, Collection<String> result) throws IOException {
        while (inputs.hasMoreElements()) {
            String nextHeaderValue = inputs.nextElement();
            if (nextHeaderValue == null) continue;
            TokenList.parseTokenList(new StringReader(nextHeaderValue), result);
        }
    }

    public static void parseTokenList(Reader input, Collection<String> result) throws IOException {
        while (true) {
            String fieldName;
            if ((fieldName = HttpParser.readToken(input)) == null) {
                HttpParser.skipUntil(input, 0, ',');
                continue;
            }
            if (fieldName.length() == 0) break;
            SkipResult skipResult = HttpParser.skipConstant(input, ",");
            if (skipResult == SkipResult.EOF) {
                result.add(fieldName.toLowerCase(Locale.ENGLISH));
                break;
            }
            if (skipResult == SkipResult.FOUND) {
                result.add(fieldName.toLowerCase(Locale.ENGLISH));
                continue;
            }
            HttpParser.skipUntil(input, 0, ',');
        }
    }
}

