/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.model.Run;
import com.google.caliper.options.CaliperDirectory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

@Singleton
final class LoggingConfigLoader {
    private static final Logger logger = Logger.getLogger(LoggingConfigLoader.class.getName());
    private final File caliperDirectory;
    private final LogManager logManager;
    private final Run run;

    @Inject
    LoggingConfigLoader(@CaliperDirectory File caliperDirectory, LogManager logManager, Run run) {
        this.caliperDirectory = caliperDirectory;
        this.logManager = logManager;
        this.run = run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Inject
    void loadLoggingConfig() {
        block11: {
            block9: {
                File loggingPropertiesFile = new File(this.caliperDirectory, "logging.properties");
                if (!loggingPropertiesFile.isFile()) break block9;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(loggingPropertiesFile);
                    this.logManager.readConfiguration(fis);
                }
                catch (SecurityException e) {
                    LoggingConfigLoader.logConfigurationException(e);
                    Closeables.closeQuietly((Closeable)fis);
                }
                catch (IOException e2) {
                    LoggingConfigLoader.logConfigurationException(e2);
                    {
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)fis);
                }
                Closeables.closeQuietly((Closeable)fis);
                logger.info(String.format("Using logging configuration at %s", loggingPropertiesFile));
                break block11;
            }
            try {
                this.maybeLoadDefaultLogConfiguration(LogManager.getLogManager());
            }
            catch (SecurityException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
            catch (IOException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
        }
    }

    @VisibleForTesting
    void maybeLoadDefaultLogConfiguration(LogManager logManager) throws SecurityException, IOException {
        logManager.reset();
        File logDirectory = new File(this.caliperDirectory, "log");
        logDirectory.mkdirs();
        FileHandler fileHandler = new FileHandler(String.format("%s/%s.%s.log", logDirectory.getAbsolutePath(), this.run.startTime(), this.run.id()));
        fileHandler.setEncoding(Charsets.UTF_8.name());
        fileHandler.setFormatter(new SimpleFormatter());
        Logger globalLogger = logManager.getLogger("");
        globalLogger.addHandler(fileHandler);
    }

    private static void logConfigurationException(Exception e) {
        logger.log(Level.WARNING, "Could not apply the logging configuration", e);
    }
}

