/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.Value;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.Immutable;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
public class Measurement {
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @Embedded
    private Value value;
    private double weight;
    @Basic(optional=false)
    private String description;

    private Measurement() {
        this.value = Value.DEFAULT;
        this.weight = 0.0;
        this.description = "";
    }

    private Measurement(Builder builder) {
        this.value = builder.value;
        this.description = builder.description;
        this.weight = builder.weight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Measurement) {
            Measurement that = (Measurement)obj;
            return this.value.equals(that.value) && this.weight == that.weight && this.description.equals(that.description);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.weight, this.description});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", (Object)this.value).add("weight", this.weight).add("description", (Object)this.description).toString();
    }

    public Value value() {
        return this.value;
    }

    public double weight() {
        return this.weight;
    }

    public String description() {
        return this.description;
    }

    public static final class Builder {
        private Value value;
        private Double weight;
        private String description;

        public Builder value(Value value) {
            this.value = (Value)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder weight(double weight) {
            Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0);
            this.weight = weight;
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public Measurement build() {
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.weight != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.description != null ? 1 : 0) != 0);
            return new Measurement(this);
        }
    }
}

