/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.JarFinder;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.worker.AllocationWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.runtime.instrumentation.AllocationInstrumenter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AllocationInstrument
extends Instrument {
    private static final String ALLOCATION_AGENT_JAR_OPTION = "allocationAgentJar";
    private static final Logger logger = Logger.getLogger(AllocationInstrumenter.class.getName());

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return Instrument.isTimeMethod(method);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        return Instrument.createBenchmarkMethodFromTimeMethod(benchmarkClass, method);
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, 1);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)ALLOCATION_AGENT_JAR_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<File> findAllocationInstrumentJarOnClasspath() throws IOException {
        for (File file : JarFinder.findJarFiles(ClassLoader.getSystemClassLoader())) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || !AllocationInstrumenter.class.getName().equals(manifest.getMainAttributes().getValue("Premain-Class"))) continue;
                Optional optional = Optional.of((Object)file);
                return optional;
            }
            finally {
                if (jarFile == null) continue;
                jarFile.close();
            }
        }
        return Optional.absent();
    }

    @Override
    ImmutableSet<String> getExtraCommandLineArgs() {
        String agentJar = (String)this.options.get((Object)ALLOCATION_AGENT_JAR_OPTION);
        if (Strings.isNullOrEmpty((String)agentJar)) {
            try {
                Optional<File> instrumentJar = AllocationInstrument.findAllocationInstrumentJarOnClasspath();
                if (instrumentJar.isPresent()) {
                    agentJar = ((File)instrumentJar.get()).getAbsolutePath();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "An exception occurred trying to locate the allocation agent jar on the classpath", e);
            }
        }
        if (Strings.isNullOrEmpty((String)agentJar) || !new File(agentJar).exists()) {
            throw new IllegalStateException("Can't find required allocationinstrumenter agent jar");
        }
        return new ImmutableSet.Builder().addAll(super.getExtraCommandLineArgs()).add((Object)("-javaagent:" + agentJar)).build();
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return AllocationWorker.class;
    }

    @Override
    Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
        return new Instrument.DefaultMeasurementCollectingVisitor((ImmutableSet<String>)ImmutableSet.of((Object)"bytes", (Object)"objects"));
    }
}

