/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.bridge.BridgeModule;
import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.ConfigModule;
import com.google.caliper.config.InvalidConfigurationException;
import com.google.caliper.json.GsonModule;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.options.OptionsModule;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.ExperimentingRunnerModule;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.OutputModule;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ObjectArrays;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.io.PrintWriter;
import java.util.Map;

public final class CaliperMain {
    private static final String LEGACY_ENV = "USE_LEGACY_CALIPER";

    public static void main(Class<? extends Benchmark> benchmarkClass, String[] args) {
        CaliperMain.main((String[])ObjectArrays.concat((Object[])args, (Object)benchmarkClass.getName()));
    }

    static void main(String[] args) {
        PrintWriter stdout = new PrintWriter(System.out, true);
        PrintWriter stderr = new PrintWriter(System.err, true);
        int code = 1;
        try {
            CaliperMain.exitlessMain(args, stdout, stderr);
            code = 0;
        }
        catch (InvalidCommandException e) {
            e.display(stderr);
            code = e.exitCode();
        }
        catch (InvalidBenchmarkException e) {
            e.display(stderr);
        }
        catch (InvalidConfigurationException e) {
            e.display(stderr);
        }
        catch (Throwable t) {
            t.printStackTrace(stderr);
            stdout.println();
            stdout.println("An unexpected exception has been thrown by the caliper runner.");
            stdout.println("Please see https://sites.google.com/site/caliperusers/issues");
        }
        stdout.flush();
        stderr.flush();
        System.exit(code);
    }

    public static void exitlessMain(String[] args, PrintWriter stdout, PrintWriter stderr) throws InvalidCommandException, InvalidBenchmarkException, InvalidConfigurationException {
        String legacyCaliperEnv = System.getenv(LEGACY_ENV);
        if (!Strings.isNullOrEmpty((String)legacyCaliperEnv)) {
            System.err.println("Legacy Caliper is no more. USE_LEGACY_CALIPER has no effect.");
        }
        try {
            Injector optionsInjector = Guice.createInjector((Module[])new Module[]{new OptionsModule(args)});
            CaliperOptions options = (CaliperOptions)optionsInjector.getInstance(CaliperOptions.class);
            ExperimentingRunnerModule runnerModule = new ExperimentingRunnerModule();
            Injector injector = optionsInjector.createChildInjector(new Module[]{new OutputModule(stdout, stderr), new BridgeModule(), new GsonModule(), new ConfigModule(), runnerModule});
            if (options.printConfiguration()) {
                stdout.println("Configuration:");
                ImmutableSortedMap sortedProperties = ImmutableSortedMap.copyOf(((CaliperConfig)injector.getInstance(CaliperConfig.class)).properties());
                for (Map.Entry entry : sortedProperties.entrySet()) {
                    stdout.printf("  %s = %s%n", entry.getKey(), entry.getValue());
                }
            }
            CaliperRun run = (CaliperRun)injector.getInstance(CaliperRun.class);
            run.run();
        }
        catch (CreationException e) {
            CaliperMain.propogateIfCaliperException(e.getCause());
            throw e;
        }
        catch (ProvisionException e) {
            Throwable cause = e.getCause();
            CaliperMain.propogateIfCaliperException(e.getCause());
            for (Message message : e.getErrorMessages()) {
                CaliperMain.propogateIfCaliperException(message.getCause());
            }
            throw e;
        }
        stderr.flush();
        stdout.flush();
    }

    private static void propogateIfCaliperException(Throwable throwable) throws InvalidCommandException, InvalidBenchmarkException, InvalidConfigurationException {
        Throwables.propagateIfInstanceOf((Throwable)throwable, InvalidCommandException.class);
        Throwables.propagateIfInstanceOf((Throwable)throwable, InvalidBenchmarkException.class);
        Throwables.propagateIfInstanceOf((Throwable)throwable, InvalidConfigurationException.class);
    }
}

