/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.VirtualMachine;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;

final class Experiment {
    private final Instrument instrument;
    private final BenchmarkMethod benchmarkMethod;
    private final VirtualMachine vm;
    private final ImmutableSortedMap<String, String> userParameters;

    Experiment(Instrument instrument, BenchmarkMethod benchmarkMethod, Map<String, String> userParameters, VirtualMachine vm) {
        this.instrument = instrument;
        this.benchmarkMethod = benchmarkMethod;
        this.userParameters = ImmutableSortedMap.copyOf(userParameters);
        this.vm = vm;
    }

    Instrument instrument() {
        return this.instrument;
    }

    BenchmarkMethod benchmarkMethod() {
        return this.benchmarkMethod;
    }

    ImmutableSortedMap<String, String> userParameters() {
        return this.userParameters;
    }

    VirtualMachine vm() {
        return this.vm;
    }

    public boolean equals(Object object) {
        if (object instanceof Experiment) {
            Experiment that = (Experiment)object;
            return this.instrument.equals(that.instrument) && this.benchmarkMethod.equals(that.benchmarkMethod) && this.vm.equals(that.vm) && this.userParameters.equals(that.userParameters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instrument, this.benchmarkMethod, this.vm, this.userParameters});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("instrument", (Object)this.instrument.name()).add("method", (Object)this.benchmarkMethod).add("vm", (Object)this.vm.name).add("parameters", this.userParameters).toString();
    }
}

