/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.InstrumentName;
import com.google.caliper.runner.InstrumentOptions;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public abstract class Instrument {
    protected ImmutableMap<String, String> options;
    private String name = this.getClass().getSimpleName();
    static final ImmutableSet<String> JVM_ARGS = ImmutableSet.of((Object)"-Xbatch", (Object)"-XX:CICompilerCount=1", (Object)"-XX:+UseParallelGC", (Object)"-Dsun.reflect.inflationThreshold=0");

    @Inject
    void setOptions(@InstrumentOptions ImmutableMap<String, String> options) {
        this.options = ImmutableMap.copyOf((Map)Maps.filterKeys(options, (Predicate)Predicates.in(this.instrumentOptions())));
    }

    @Inject
    void setInstrumentName(@InstrumentName String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public abstract boolean isBenchmarkMethod(Method var1);

    public abstract BenchmarkMethod createBenchmarkMethod(BenchmarkClass var1, Method var2) throws InvalidBenchmarkException;

    public abstract void dryRun(Benchmark var1, BenchmarkMethod var2) throws InvalidBenchmarkException;

    public final ImmutableMap<String, String> options() {
        return this.options;
    }

    public ImmutableMap<String, String> workerOptions() {
        return this.options;
    }

    public abstract Class<? extends Worker> workerClass();

    final InstrumentSpec getSpec() {
        return new InstrumentSpec.Builder().instrumentClass(this.getClass()).addAllOptions((Map<String, String>)this.options()).build();
    }

    protected ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of();
    }

    ImmutableSet<String> getExtraCommandLineArgs() {
        return JVM_ARGS;
    }

    public static boolean isTimeMethod(Method method) {
        return method.getName().startsWith("time") && Util.isPublic(method);
    }

    public static BenchmarkMethod createBenchmarkMethodFromTimeMethod(BenchmarkClass benchmarkClass, Method timeMethod) throws InvalidBenchmarkException {
        Preconditions.checkArgument((boolean)Instrument.isTimeMethod(timeMethod));
        Object[] parameterTypes = timeMethod.getParameterTypes();
        if (!Arrays.equals(parameterTypes, new Class[]{Integer.TYPE}) && !Arrays.equals(parameterTypes, new Class[]{Long.TYPE})) {
            throw new InvalidBenchmarkException("Microbenchmark methods must accept a single int parameter: " + timeMethod.getName(), new Object[0]);
        }
        if (Util.isStatic(timeMethod)) {
            throw new InvalidBenchmarkException("Microbenchmark methods must not be static: " + timeMethod.getName(), new Object[0]);
        }
        String methodName = timeMethod.getName();
        String shortName = methodName.substring("time".length());
        return new BenchmarkMethod(benchmarkClass, timeMethod, shortName);
    }

    abstract MeasurementCollectingVisitor getMeasurementCollectingVisitor();

    protected static final class DefaultMeasurementCollectingVisitor
    extends AbstractLogMessageVisitor
    implements MeasurementCollectingVisitor {
        static final int DEFAULT_NUMBER_OF_MEASUREMENTS = 9;
        final ImmutableSet<String> requiredDescriptions;
        final ListMultimap<String, Measurement> measurementsByDescription;
        final int requiredMeasurements;

        DefaultMeasurementCollectingVisitor(ImmutableSet<String> requiredDescriptions) {
            this(requiredDescriptions, 9);
        }

        DefaultMeasurementCollectingVisitor(ImmutableSet<String> requiredDescriptions, int requiredMeasurements) {
            this.requiredDescriptions = requiredDescriptions;
            Preconditions.checkArgument((!requiredDescriptions.isEmpty() ? 1 : 0) != 0);
            this.requiredMeasurements = requiredMeasurements;
            Preconditions.checkArgument((requiredMeasurements > 0 ? 1 : 0) != 0);
            this.measurementsByDescription = ArrayListMultimap.create((int)requiredDescriptions.size(), (int)requiredMeasurements);
        }

        @Override
        public void visit(StopMeasurementLogMessage logMessage) {
            for (Measurement measurement : logMessage.measurements()) {
                this.measurementsByDescription.put((Object)measurement.description(), (Object)measurement);
            }
        }

        @Override
        public boolean isDoneCollecting() {
            for (String description : this.requiredDescriptions) {
                if (this.measurementsByDescription.get((Object)description).size() >= this.requiredMeasurements) continue;
                return false;
            }
            return true;
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf((Collection)this.measurementsByDescription.values());
        }
    }

    static interface MeasurementCollectingVisitor
    extends LogMessageVisitor {
        public boolean isDoneCollecting();

        public ImmutableList<Measurement> getMeasurements();
    }
}

