/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.NanoTimeGranularity;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.caliper.worker.MicrobenchmarkWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class MicrobenchmarkInstrument
extends Instrument {
    private static final Logger logger = Logger.getLogger(MicrobenchmarkInstrument.class.getName());
    private static final String TIMING_INTERVAL_OPTION = "timingInterval";
    private final PrintWriter stdout;
    private final PrintWriter stderr;
    private final ShortDuration nanoTimeGranularity;

    @Inject
    MicrobenchmarkInstrument(@NanoTimeGranularity ShortDuration nanoTimeGranularity, @Stdout PrintWriter stdout, @Stderr PrintWriter stderr) {
        this.nanoTimeGranularity = nanoTimeGranularity;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return Instrument.isTimeMethod(method);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        return Instrument.createBenchmarkMethodFromTimeMethod(benchmarkClass, method);
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, 1);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"warmup", (Object)TIMING_INTERVAL_OPTION, (Object)"measurements", (Object)"gcBeforeEach");
    }

    @Override
    public ImmutableMap<String, String> workerOptions() {
        return new ImmutableMap.Builder().put((Object)"timingIntervalNanos", (Object)this.toNanosString(TIMING_INTERVAL_OPTION)).put((Object)"gcBeforeEach", this.options.get((Object)"gcBeforeEach")).build();
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return MicrobenchmarkWorker.class;
    }

    private String toNanosString(String optionName) {
        return String.valueOf(ShortDuration.valueOf((String)this.options.get((Object)optionName)).to(TimeUnit.NANOSECONDS));
    }

    public boolean equals(Object object) {
        return object instanceof MicrobenchmarkInstrument;
    }

    public int hashCode() {
        return 1609079866;
    }

    @Override
    Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
        return new RuntimeMeasurementCollector(this.getMeasurementsPerTrial(), ShortDuration.valueOf((String)this.options.get((Object)"warmup")));
    }

    private int getMeasurementsPerTrial() {
        String measurementsString = (String)this.options.get((Object)"measurements");
        int measurementsPerTrial = measurementsString == null ? 1 : Integer.parseInt(measurementsString);
        Preconditions.checkState((measurementsPerTrial > 0 ? 1 : 0) != 0);
        return measurementsPerTrial;
    }

    private final class RuntimeMeasurementCollector
    extends AbstractLogMessageVisitor
    implements Instrument.MeasurementCollectingVisitor {
        final int measurementsPerTrial;
        final ShortDuration warmup;
        final List<Measurement> measurements = Lists.newArrayList();
        boolean timing = false;
        boolean invalidMeasurements = false;
        ShortDuration elapsedWarmup = ShortDuration.zero();

        RuntimeMeasurementCollector(int measurementsPerTrial, ShortDuration warmup) {
            this.measurementsPerTrial = measurementsPerTrial;
            this.warmup = warmup;
        }

        boolean isInWarmup() {
            return this.elapsedWarmup.compareTo(this.warmup) < 0;
        }

        @Override
        public void visit(GcLogMessage logMessage) {
            if (this.timing && !this.isInWarmup()) {
                this.invalidMeasurements = true;
                MicrobenchmarkInstrument.this.stderr.println("ERROR: GC occurred during timing.");
            }
        }

        @Override
        public void visit(HotspotLogMessage logMessage) {
            if (!this.isInWarmup()) {
                if (this.timing) {
                    MicrobenchmarkInstrument.this.stderr.println("ERROR: Hotspot compilation occurred during timing. Warmup is likely insufficent.");
                } else {
                    MicrobenchmarkInstrument.this.stdout.println("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Results may be affected. Run with --verbose to see which method was compiled.");
                }
            }
        }

        @Override
        public void visit(StartMeasurementLogMessage logMessage) {
            Preconditions.checkState((!this.timing ? 1 : 0) != 0);
            this.timing = true;
        }

        @Override
        public void visit(StopMeasurementLogMessage logMessage) {
            Preconditions.checkState((boolean)this.timing);
            ImmutableList<Measurement> newMeasurements = logMessage.measurements();
            if (this.isInWarmup()) {
                for (Measurement measurement : newMeasurements) {
                    Preconditions.checkArgument((boolean)"ns".equals(measurement.value().unit()));
                    this.elapsedWarmup = this.elapsedWarmup.plus(ShortDuration.of(BigDecimal.valueOf(measurement.value().magnitude()), TimeUnit.NANOSECONDS));
                }
            } else if (this.invalidMeasurements) {
                logger.fine(String.format("Discarding %s as they were marked invalid.", newMeasurements));
            } else {
                this.measurements.addAll((Collection<Measurement>)newMeasurements);
            }
            this.invalidMeasurements = false;
            this.timing = false;
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurements.size() >= this.measurementsPerTrial;
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            boolean improperGranularity = true;
            for (Measurement measurement : this.measurements) {
                Preconditions.checkState((boolean)"ns".equals(measurement.value().unit()));
                double nanos = measurement.value().magnitude() / measurement.weight();
                improperGranularity &= nanos / 1000.0 > (double)MicrobenchmarkInstrument.this.nanoTimeGranularity.to(TimeUnit.NANOSECONDS);
            }
            if (improperGranularity) {
                ShortDuration reasonableUpperBound = MicrobenchmarkInstrument.this.nanoTimeGranularity.times(1000L);
                MicrobenchmarkInstrument.this.stderr.printf("INFO: This experiment does not require a microbenchmark. The granularity of the timer (%s) is less than 0.1%% of the measured runtime. If all experiments for this benchmark have runtimes greater than %s, consider the macrobenchmark instrument.%n", MicrobenchmarkInstrument.this.nanoTimeGranularity, reasonableUpperBound);
            }
            return ImmutableList.copyOf(this.measurements);
        }
    }
}

