/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Ticker;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class MicrobenchmarkWorker
implements Worker {
    @VisibleForTesting
    static final int INITIAL_REPS = 100;
    private final Random random;
    private final Ticker ticker;

    @Inject
    MicrobenchmarkWorker(Random random, Ticker ticker) {
        this.random = random;
        this.ticker = ticker;
    }

    @Override
    public void measure(Benchmark benchmark, String methodName, Map<String, String> optionMap, WorkerEventLog log) throws Exception {
        Options options = new Options(optionMap);
        Trial trial = this.createTrial(benchmark, methodName, options, log);
        long warmupNanos = trial.warmUp(100);
        trial.run(100, warmupNanos);
    }

    private Trial createTrial(Benchmark benchmark, String methodName, Options options, WorkerEventLog log) {
        final String timeMethodName = "time" + methodName;
        Iterable timeMethods = Iterables.filter(Arrays.asList(benchmark.getClass().getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return timeMethodName.equals(input.getName());
            }
        });
        Method timeMethod = (Method)Iterables.getOnlyElement((Iterable)timeMethods);
        timeMethod.setAccessible(true);
        Class repsType = (Class)Iterables.getOnlyElement(Arrays.asList(timeMethod.getParameterTypes()));
        if (Integer.TYPE.equals(repsType)) {
            return new IntTrial(benchmark, timeMethod, options, log);
        }
        if (Long.TYPE.equals(repsType)) {
            return new LongTrial(benchmark, timeMethod, options, log);
        }
        throw new IllegalStateException(String.format("Got a benchmark method (%s) with an invalid reps parameter.", timeMethod));
    }

    @VisibleForTesting
    static long calculateTargetReps(long reps, long nanos, long targetNanos, double gaussian) {
        double targetReps = (double)reps / (double)nanos * (double)targetNanos;
        return Math.max(1L, Math.round(gaussian * (targetReps / 5.0) + targetReps));
    }

    private static final class Options {
        long timingIntervalNanos;
        boolean gcBeforeEach;

        Options(Map<String, String> optionMap) {
            this.timingIntervalNanos = Long.parseLong(optionMap.get("timingIntervalNanos"));
            this.gcBeforeEach = Boolean.parseBoolean(optionMap.get("gcBeforeEach"));
        }
    }

    private final class LongTrial
    extends Trial {
        LongTrial(Benchmark benchmark, Method timeMethod, Options options, WorkerEventLog log) {
            super(benchmark, timeMethod, options, log);
        }

        @Override
        long invokeTimeMethod(long reps) throws Exception {
            long before = MicrobenchmarkWorker.this.ticker.read();
            this.timeMethod.invoke((Object)this.benchmark, reps);
            return MicrobenchmarkWorker.this.ticker.read() - before;
        }
    }

    private final class IntTrial
    extends Trial {
        IntTrial(Benchmark benchmark, Method timeMethod, Options options, WorkerEventLog log) {
            super(benchmark, timeMethod, options, log);
        }

        @Override
        long invokeTimeMethod(long reps) throws Exception {
            int intReps = (int)reps;
            if (reps != (long)intReps) {
                throw new InvalidBenchmarkException("%s.%s takes an int for reps, but requires a greater number to fill the given timing interval (%s). If this is expected (the benchmarked code is very fast), use a long parameter.Otherwise, check your benchmark for errors.", this.benchmark.getClass(), this.timeMethod.getName(), ShortDuration.of(this.options.timingIntervalNanos, TimeUnit.NANOSECONDS));
            }
            long before = MicrobenchmarkWorker.this.ticker.read();
            this.timeMethod.invoke((Object)this.benchmark, intReps);
            return MicrobenchmarkWorker.this.ticker.read() - before;
        }
    }

    private abstract class Trial {
        final Benchmark benchmark;
        final Method timeMethod;
        final Options options;
        final WorkerEventLog log;

        Trial(Benchmark benchmark, Method timeMethod, Options options, WorkerEventLog log) {
            this.benchmark = benchmark;
            this.timeMethod = timeMethod;
            this.options = options;
            this.log = log;
        }

        long warmUp(int warmupReps) throws Exception {
            this.log.notifyWarmupPhaseStarting();
            return this.invokeTimeMethod(warmupReps);
        }

        void run(int warmupReps, long warmupNanos) throws Exception {
            this.log.notifyMeasurementPhaseStarting();
            long totalReps = warmupReps;
            long totalNanos = warmupNanos;
            while (true) {
                long reps = MicrobenchmarkWorker.calculateTargetReps(totalReps, totalNanos, this.options.timingIntervalNanos, MicrobenchmarkWorker.this.random.nextGaussian());
                if (this.options.gcBeforeEach) {
                    Util.forceGc();
                }
                Measurement.Builder measurementBuilder = new Measurement.Builder().description("runtime");
                this.log.notifyMeasurementStarting();
                long nanos = this.invokeTimeMethod(reps);
                this.log.notifyMeasurementEnding(measurementBuilder.value(Value.create(nanos, "ns")).weight(reps).build());
                totalReps += reps;
                totalNanos += nanos;
            }
        }

        abstract long invokeTimeMethod(long var1) throws Exception;
    }
}

