-- phpMyAdmin SQL Dump
-- version 4.2.12deb2+deb8u2
-- http://www.phpmyadmin.net
--
-- 主機: mysql:3306
-- 產生時間： 2020 年 09 月 25 日 06:30
-- 伺服器版本: 5.5.60-0+deb7u1
-- PHP 版本： 5.6.24-0+deb8u1

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- 資料庫： `ecom`
--

-- --------------------------------------------------------

--
-- 資料表結構 `device`
--

CREATE TABLE IF NOT EXISTS `device` (
  `id` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '設備名稱',
  `host` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '設備位址',
  `port` int(11) NOT NULL COMMENT '設備連接埠',
  `type` int(11) DEFAULT NULL COMMENT '設備類型',
  `location` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '設備位置',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '設備停用時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

--
-- 資料表的匯出資料 `device`
--

INSERT INTO `device` (`id`, `host`, `port`, `type`, `location`, `created`, `updated`, `deleted`) VALUES
('12321SSSH7ED', '10.0.0.100', 6060, 4, '群上', '1090925142624', '1090925142624', NULL);

-- --------------------------------------------------------

--
-- 資料表結構 `device_group`
--

CREATE TABLE IF NOT EXISTS `device_group` (
`no` int(11) NOT NULL COMMENT '設備群組',
  `name` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '設備名稱',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '設備停用時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `device_group_relation`
--

CREATE TABLE IF NOT EXISTS `device_group_relation` (
  `device_id` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '設備編號',
  `device_group_id` int(11) NOT NULL COMMENT '設備群組編號',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '停用時間	'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `device_type`
--

CREATE TABLE IF NOT EXISTS `device_type` (
`no` int(11) NOT NULL COMMENT '設備類型編號',
  `name` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '設備類型名稱',
  `vendor` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '設備供應商',
  `vendor_contact_person` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '設備供應商聯絡人',
  `vendor_contact_way` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '設備供應商聯絡方式',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備類型新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '設備類型更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '設備類型刪除時間'
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

--
-- 資料表的匯出資料 `device_type`
--

INSERT INTO `device_type` (`no`, `name`, `vendor`, `vendor_contact_person`, `vendor_contact_way`, `created`, `updated`, `deleted`) VALUES
(2, 'AI', 'ecom', 'None', 'None', '1090806102747', '1090806102747', NULL),
(4, '額溫人臉辨識機', 'ecom', 'None', 'None', '1090811165302', '1090811165302', NULL),
(5, '腕溫人臉辨識機', NULL, 'None', 'None', '1090811170903', '1090811170903', NULL);

-- --------------------------------------------------------

--
-- 資料表結構 `person`
--

CREATE TABLE IF NOT EXISTS `person` (
`no` int(11) NOT NULL COMMENT 'Person number',
  `id` varchar(10) COLLATE utf8_bin NOT NULL COMMENT 'Person ID',
  `name` varchar(10) COLLATE utf8_bin NOT NULL COMMENT 'Person Name',
  `sex` int(11) NOT NULL COMMENT 'Person Sex',
  `type` int(11) NOT NULL COMMENT 'Person Type',
  `token` text COLLATE utf8_bin COMMENT 'Person Line Token',
  `photo` mediumtext COLLATE utf8_bin COMMENT 'Person Photo',
  `start` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT 'Person Start Time',
  `end` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT 'Person End Time',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT 'Person Insert Time',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT 'Person Update Time',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT 'Person Delete Time'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `person_group`
--

CREATE TABLE IF NOT EXISTS `person_group` (
`no` int(11) NOT NULL COMMENT '人員群組編號',
  `name` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '人員群組名稱',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '人員群組新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '人員群組更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '人員群組刪除時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `person_group_and_device_group_relation`
--

CREATE TABLE IF NOT EXISTS `person_group_and_device_group_relation` (
  `person_group_id` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '人員群組編號',
  `device_group_id` int(11) NOT NULL COMMENT '設備群組編號',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '新增日期時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '修改日期時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '刪除日期時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `person_group_relation`
--

CREATE TABLE IF NOT EXISTS `person_group_relation` (
  `person_id` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '人員ID',
  `person_group_id` int(11) NOT NULL COMMENT '人員群組ID',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '新增日期時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '修改日期時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '刪除日期時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `person_type`
--

CREATE TABLE IF NOT EXISTS `person_type` (
`id` int(11) NOT NULL COMMENT 'Person Type ID',
  `name` varchar(10) COLLATE utf8_bin NOT NULL COMMENT 'Person Type Name',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT 'Person Type Insert Time',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT 'Person Type Update Time',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT 'Person Type Delete Time'
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

--
-- 資料表的匯出資料 `person_type`
--

INSERT INTO `person_type` (`id`, `name`, `created`, `updated`, `deleted`) VALUES
(1, 'Black List', '1090617112737', '1090617112738', NULL),
(2, 'White List', '1090617112649', '1090617112649', NULL),
(3, 'VIP List', '1090617112750', '1090617112750', NULL);

-- --------------------------------------------------------

--
-- 資料表結構 `server`
--

CREATE TABLE IF NOT EXISTS `server` (
  `id` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '伺服器名稱',
  `host` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '伺服器位址',
  `port` int(11) NOT NULL COMMENT '伺服器連接埠',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '伺服器新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '伺服器更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '伺服器停用時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `user`
--

CREATE TABLE IF NOT EXISTS `user` (
  `id` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '使用者編號',
  `name` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '使用者名稱',
  `role` int(11) DEFAULT NULL COMMENT '使用者角色',
  `username` varchar(15) COLLATE utf8_bin NOT NULL COMMENT '使用者帳號',
  `password` text COLLATE utf8_bin NOT NULL COMMENT '使用者密碼',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '使用者新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '使用者更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '使用者停用時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

--
-- 資料表的匯出資料 `user`
--

INSERT INTO `user` (`id`, `name`, `role`, `username`, `password`, `created`, `updated`, `deleted`) VALUES
('admin', 'admin', 5, 'admin', '$pbkdf2-sha256$29000$Xkup1bo3pnQupRSiFML4fw$fk6FVqQW0i7j3tx5fTkrWhSi3Gvb7CRkA1tOT4PanRc', '1090925142941', '1090925142941', NULL),
('root', 'root', 3, 'root', '$pbkdf2-sha256$29000$J2Ts/R.DUGrNWcvZW8uZ0w$zWNkdq0FVe5VEcRiXFcaWpK4c557CxbnxlkbJsKVGT4', '1090925143025', '1090925143025', NULL);

-- --------------------------------------------------------

--
-- 資料表結構 `user_feature`
--

CREATE TABLE IF NOT EXISTS `user_feature` (
`no` int(11) NOT NULL COMMENT '使用者特徵流水號',
  `id` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '使用者編號',
  `features` text COLLATE utf8_bin NOT NULL COMMENT '使用者特徵',
  `description` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '使用者特徵描述',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '使用者特徵新增時間 \r\n',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '使用者特徵更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '使用者特徵停用時間'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 資料表結構 `user_role`
--

CREATE TABLE IF NOT EXISTS `user_role` (
`id` int(11) NOT NULL COMMENT '角色編號',
  `name` varchar(10) COLLATE utf8_bin NOT NULL COMMENT '角色名稱',
  `created` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '角色新增時間',
  `updated` varchar(13) COLLATE utf8_bin NOT NULL COMMENT '角色更新時間',
  `deleted` varchar(13) COLLATE utf8_bin DEFAULT NULL COMMENT '角色停用時間'
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

--
-- 資料表的匯出資料 `user_role`
--

INSERT INTO `user_role` (`id`, `name`, `created`, `updated`, `deleted`) VALUES
(3, 'Manager', '1090616173403', '1090616173403', NULL),
(5, 'User', '1090616173714', '1090616173714', NULL);

--
-- 已匯出資料表的索引
--

--
-- 資料表索引 `device`
--
ALTER TABLE `device`
 ADD PRIMARY KEY (`id`), ADD KEY `device_type` (`type`) USING BTREE;

--
-- 資料表索引 `device_group`
--
ALTER TABLE `device_group`
 ADD PRIMARY KEY (`no`);

--
-- 資料表索引 `device_group_relation`
--
ALTER TABLE `device_group_relation`
 ADD KEY `device_id` (`device_id`), ADD KEY `device_group_id` (`device_group_id`);

--
-- 資料表索引 `device_type`
--
ALTER TABLE `device_type`
 ADD PRIMARY KEY (`no`);

--
-- 資料表索引 `person`
--
ALTER TABLE `person`
 ADD PRIMARY KEY (`no`), ADD UNIQUE KEY `id` (`id`), ADD KEY `person_type` (`type`);

--
-- 資料表索引 `person_group`
--
ALTER TABLE `person_group`
 ADD PRIMARY KEY (`no`);

--
-- 資料表索引 `person_group_relation`
--
ALTER TABLE `person_group_relation`
 ADD KEY `person_id` (`person_id`), ADD KEY `person_group_id` (`person_group_id`);

--
-- 資料表索引 `person_type`
--
ALTER TABLE `person_type`
 ADD PRIMARY KEY (`id`);

--
-- 資料表索引 `user`
--
ALTER TABLE `user`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `username` (`username`), ADD KEY `user_role` (`role`);

--
-- 資料表索引 `user_feature`
--
ALTER TABLE `user_feature`
 ADD PRIMARY KEY (`no`), ADD KEY `user` (`id`);

--
-- 資料表索引 `user_role`
--
ALTER TABLE `user_role`
 ADD PRIMARY KEY (`id`);

--
-- 在匯出的資料表使用 AUTO_INCREMENT
--

--
-- 使用資料表 AUTO_INCREMENT `device_group`
--
ALTER TABLE `device_group`
MODIFY `no` int(11) NOT NULL AUTO_INCREMENT COMMENT '設備群組';
--
-- 使用資料表 AUTO_INCREMENT `device_type`
--
ALTER TABLE `device_type`
MODIFY `no` int(11) NOT NULL AUTO_INCREMENT COMMENT '設備類型編號',AUTO_INCREMENT=6;
--
-- 使用資料表 AUTO_INCREMENT `person`
--
ALTER TABLE `person`
MODIFY `no` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Person number';
--
-- 使用資料表 AUTO_INCREMENT `person_group`
--
ALTER TABLE `person_group`
MODIFY `no` int(11) NOT NULL AUTO_INCREMENT COMMENT '人員群組編號';
--
-- 使用資料表 AUTO_INCREMENT `person_type`
--
ALTER TABLE `person_type`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Person Type ID',AUTO_INCREMENT=4;
--
-- 使用資料表 AUTO_INCREMENT `user_feature`
--
ALTER TABLE `user_feature`
MODIFY `no` int(11) NOT NULL AUTO_INCREMENT COMMENT '使用者特徵流水號';
--
-- 使用資料表 AUTO_INCREMENT `user_role`
--
ALTER TABLE `user_role`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '角色編號',AUTO_INCREMENT=6;
--
-- 已匯出資料表的限制(Constraint)
--

--
-- 資料表的 Constraints `device`
--
ALTER TABLE `device`
ADD CONSTRAINT `type_no` FOREIGN KEY (`type`) REFERENCES `device_type` (`no`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- 資料表的 Constraints `device_group_relation`
--
ALTER TABLE `device_group_relation`
ADD CONSTRAINT `device_group_relation_ibfk_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`),
ADD CONSTRAINT `device_group_relation_ibfk_2` FOREIGN KEY (`device_group_id`) REFERENCES `device_group` (`no`);

--
-- 資料表的 Constraints `person`
--
ALTER TABLE `person`
ADD CONSTRAINT `person_type` FOREIGN KEY (`type`) REFERENCES `person_type` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- 資料表的 Constraints `person_group_relation`
--
ALTER TABLE `person_group_relation`
ADD CONSTRAINT `person_group_relation_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `person` (`id`),
ADD CONSTRAINT `person_group_relation_ibfk_2` FOREIGN KEY (`person_group_id`) REFERENCES `person_group` (`no`);

--
-- 資料表的 Constraints `user`
--
ALTER TABLE `user`
ADD CONSTRAINT `user_role` FOREIGN KEY (`role`) REFERENCES `user_role` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- 資料表的 Constraints `user_feature`
--
ALTER TABLE `user_feature`
ADD CONSTRAINT `user` FOREIGN KEY (`id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
