from base_resource import BaseResource
from mysql_model import DeviceGroupModel

# ========== 新增裝置資源 ==========
class DeviceGroupInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDeviceGroup")
        self.parser.add_argument('name', required=True, help="設備群組名稱，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceGroupModel.FromDBByName(args['name'], self.log.SetMessage)
        if not model.isExist:
            model.SetName(args['name'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "{0} inserted".format(args['name'])
            else:
                self.message = "{0} insert failed".format(args['name'])
        else:
            self.message = "{0} is exist in database".format(args['name'])
        return self.GetResponse()

# ========== 更新裝置資源 ==========
class DeviceGroupUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDeviceGroup")
        self.parser.add_argument('id', required=True, help="設備群組編號")
        self.parser.add_argument('name', help="設備群組名稱，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceGroupModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            model.SetName(args['name'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeName():
                    self.message.append(
                        "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "{0} failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 刪除裝置資源 ==========
class DeviceGroupDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDeviceGroup")
        self.parser.add_argument('id', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DeviceGroupModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['id'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class DeviceGroupSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllDeviceGroup")
    def post(self, ID=None):
        models = DeviceGroupModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()