from base_resource import BaseResource
from device_shift_relation_model import DeviceShiftRelationModel
# from werkzeug.datastructures import FileStorage
import os, werkzeug, base64, pandas as pd

# ========== 新增設備班別關係記錄 ==========
class DeviceShiftRelationInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDeviceShiftRelation")
        self.parser.add_argument('device_id', required=True, help="設備編號，上限20字")
        self.parser.add_argument('shift_no', required=True, help="班別編號，上限20字")
        self.parser.add_argument('note', help="備註")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceShiftRelationModel.FromDBByDeviceIdShiftNo(args['device_id'],args['shift_no'], self.log.SetMessage)
        if not model.isExist:
            model.SetDeviceId(args['device_id'])
            model.SetShiftNo(args['shift_no'])
            model.SetNote(args['note'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "DeviceShiftRelation：{0}, {1} inserted".format(args['device_id'],args['shift_no'])
            else:
                self.message = "DeviceShiftRelation：{0}, {1} insert failed".format(args['device_id'],args['shift_no'])
        else:
            self.message = "DeviceShiftRelation：{0}, {1} is exist in database".format(args['device_id'],args['shift_no'])
        return self.GetResponse()

# ========== 更新設備班別關係紀錄 ==========
class DeviceShiftRelationUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDeviceShiftRelation")
        self.parser.add_argument('no', required=True, help="班別編號")
        self.parser.add_argument('device_id', required=True, help="設備編號，上限20字")
        self.parser.add_argument('shift_no', required=True, help="班別編號，上限20字")
        self.parser.add_argument('note', help="備註")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceShiftRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetDeviceId(args['device_id'])
            model.SetShiftNo(args['shift_no'])
            model.SetNote(args['note'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeDeviceId():
                    self.message.append(
                        "DeviceId: {0} -> {1}".format(model.GetOldDeviceId(), model.GetDeviceId())
                    )
                if model.HasChangeShiftNo():
                    self.message.append(
                        "ShiftNo: {0} -> {1}".format(model.GetOldShiftNo(), model.GetShiftNo())
                    )
                if model.HasChangeNote():
                    self.message.append(
                        "Note: {0} -> {1}".format(model.GetOldNote(), model.GetNote())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "DeviceShiftRelation：{0}, {1} update failed".format(args['device_id'],args['shift_no'])
        else:
            self.message = "DeviceShiftRelation：{0}, {1} isn't exist in database".format(args['device_id'],args['shift_no'])
        return self.GetResponse()
# ========== 刪除設備班別關係紀錄 ==========
class DeviceShiftRelationDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDeviceShiftRelation")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DeviceShiftRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "DeviceShiftRelation：{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "DeviceShiftRelation：{0} delete failed".format(args['no'])
        else:
            self.message = "DeviceShiftRelation：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有設備班別關係紀錄 ==========
class DeviceShiftRelationSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectDeviceShiftRelation")
    def post(self, ID=None):
        models = DeviceShiftRelationModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    