from base_resource import BaseResource
from leave_signing_status_model import LeaveSigningStatusModel

# ========== 新增簽呈狀況 ==========
class LeaveSigningStatusInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertLeaveSingingStatus")
        self.parser.add_argument('leave_off_work_no', required=True, help="請假單號")
        self.parser.add_argument('depart_leave_unit_department', help="隸屬部門")
        self.parser.add_argument('signing_status_1', help="簽呈單位-狀況1")     #1是True，0是False 
        self.parser.add_argument('signing_status_2', help="簽呈單位-狀況2")
        self.parser.add_argument('signing_status_3', help="簽呈單位-狀況3")
        self.parser.add_argument('signing_status_4', help="簽呈單位-狀況4(老闆)")
    def post(self):
        args = self.parser.parse_args()
        model = LeaveSigningStatusModel.FromDBByLeaveOffWorkNo(args['leave_off_work_no'], self.log.SetMessage)
        if not model.isExist:
            model.SetLeaveOffWorkNo(args['leave_off_work_no'])
            model.SetDepartLeaveUnitDepartment(args['depart_leave_unit_department'])
            model.SetSigningStatus1(args['signing_status_1'])
            model.SetSigningStatus2(args['signing_status_2'])
            model.SetSigningStatus3(args['signing_status_3'])
            model.SetSigningStatus4(args['signing_status_4'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "LeaveOffWork：{0} inserted".format(args['leave_off_work_no'])
            else:
                self.message = "LeaveOffWork：{0} insert failed".format(args['leave_off_work_no'])
        else:
            self.message = "LeaveOffWork：{0} is exist in database".format(args['leave_off_work_no'])
        return self.GetResponse()

# ========== 更新簽呈狀況 ==========
class LeaveSigningStatusUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateLeaveSigningStatus")
        self.parser.add_argument('no', required=True, help="簽呈編號")        
        self.parser.add_argument('leave_off_work_no', required=True, help="請假單號")
        self.parser.add_argument('depart_leave_unit_department', help="隸屬部門")
        self.parser.add_argument('signing_status_1', help="簽呈單位-狀況1")     #1是True，0是False 
        self.parser.add_argument('signing_status_2', help="簽呈單位-狀況2")
        self.parser.add_argument('signing_status_3', help="簽呈單位-狀況3")
        self.parser.add_argument('signing_status_4', help="簽呈單位-狀況4(老闆)")
    def post(self):
        args = self.parser.parse_args()
        model = LeaveSigningStatusModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetLeaveOffWorkNo(args['leave_off_work_no'])
            model.SetDepartLeaveUnitDepartment(args['depart_leave_unit_department'])
            model.SetSigningStatus1(args['signing_status_1'])
            model.SetSigningStatus2(args['signing_status_2'])
            model.SetSigningStatus3(args['signing_status_3'])
            model.SetSigningStatus4(args['signing_status_4'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeLeaveOffWorkNo():
                    self.message.append(
                        "LeaveOffWorkNo: {0} -> {1}".format(model.GetOldLeaveOffWorkNo(), model.GetLeaveOffWorkNo())
                    )
                if model.HasChangeDepartLeaveUnitDepartment():
                    self.message.append(
                        "DepartLeaveUnitDepartment: {0} -> {1}".format(model.GetOldDepartLeaveUnitDepartment(), model.GetDepartLeaveUnitDepartment())
                    )
                if model.HasChangeSigningStatus1():
                    self.message.append(
                        "SigningStatus1: {0} -> {1}".format(model.GetOldSigningStatus1(), model.GetSigningStatus1())
                    )
                if model.HasChangeSigningStatus2():
                    self.message.append(
                        "SigningStatus2: {0} -> {1}".format(model.GetOldSigningStatus2(), model.GetSigningStatus2())
                    )  
                if model.HasChangeSigningStatus3():
                    self.message.append(
                        "SigningStatus3: {0} -> {1}".format(model.GetOldSigningStatus3(), model.GetSigningStatus3())
                    )
                if model.HasChangeSigningStatus4():
                    self.message.append(
                        "SigningStatus4: {0} -> {1}".format(model.GetOldSigningStatus4(), model.GetSigningStatus4())
                    ) 
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "LeaveOffWork：{0} update failed".format(args['leave_off_work_no'])
        else:
            self.message = "LeaveOffWork：{0} isn't exist in database".format(args['leave_off_work_no'])
        return self.GetResponse()
# ========== 刪除簽呈狀況 ==========
class LeaveSigningStatusDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteLeaveSigningStatus")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = LeaveSigningStatusModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['no'])
        else:
            self.message = "{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有簽呈狀況 ==========
class LeaveSigningStatusSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectLeaveSigningStatus")
    def post(self, ID=None):
        models = LeaveSigningStatusModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    