from base_resource import BaseResource
from mysql_model import PersonGroupRelationModel,PersonGroupModel,PersonModel

# 針對設備與群組的關聯只有加入或退出群組關聯，無更新方法
# ========== 新增裝置與群組資源 ==========
class PersonGroupRelationInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertPersonGroupRelation")
        self.parser.add_argument('person_id', required=True, help="設備編號，上限 15 字")
        self.parser.add_argument('person_group_id', required=True, help="群組編號，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        person_model = PersonModel.FromDB(args['person_id'], self.log.SetMessage)
        group_model = PersonGroupModel.FromDB(args['person_group_id'], self.log.SetMessage)
        
        if person_model.isExist and group_model.isExist:
            relation_model=PersonGroupRelationModel.FromDB(args['person_id'],args['person_group_id'], self.log.SetMessage)
            if not relation_model.isExist:
                if relation_model.InsertToDB(self.log.SetMessage):
                    self.message = "person {} and group {} relation inserted".format(args['person_id'],args['person_group_id'])
                else:
                    self.message =  "person {} and group {} relation insert failed".format(args['person_id'],args['person_group_id'])
            else:
                    self.message = "person {} and group {} relation is exist in database".format(args['person_id'],args['person_group_id'])
        else:
            self.message = "person {} or group {} is not exist in database".format(args['person_id'],args['person_group_id'])
        return self.GetResponse()

# ========== 更新裝置資源 ==========
# class PersonGroupRelationUpdate(BaseResource):
#     def __init__(self):
#         super().__init__("UpdatePersonGroupRelation")
#         self.parser.add_argument('id', required=True, help="設備群組編號")
#         self.parser.add_argument('name', help="設備群組名稱，上限 15 字")
#     def post(self):
#         args = self.parser.parse_args()
#         model = PersonGroupModel.FromDB(args['id'], self.log.SetMessage)
#         if model.isExist:
#             model.SetName(args['name'])
#             if model.UpdateToDB(self.log.SetMessage):
#                 self.message = []
#                 if model.HasChangeName():
#                     self.message.append(
#                         "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
#                     )
#                 self.message = ", ".join(self.message) if len(self.message) > 0 else ""
#             else:
#                 self.message = "{0} failed".format(args['id'])
#         else:
#             self.message = "{0} isn't exist in database".format(args['id'])
#         return self.GetResponse()
# ========== 刪除裝置資源 ==========
class PersonGroupRelationDelete(BaseResource):
    def __init__(self):
        super().__init__("DeletePersonGroupRelation")
        self.parser.add_argument('person_id', required=True, help="設備編號，上限 15 字")
        self.parser.add_argument('person_group_id', required=True, help="群組編號，上限 15 字")
    def post(self):
        args = self.parser.parse_args()
        model = PersonGroupRelationModel.FromDB(args['person_id'],args['person_group_id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "person {} and group {} relation deleted".format(args['person_id'],args['person_group_id'])
            else:
                self.message = "person {} and group {} relation delete failed".format(args['person_id'],args['person_group_id'])
        else:
            self.message = "person {} or group {} is not exist in database".format(args['person_id'],args['person_group_id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class PersonGroupRelationSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllPersonGroupRelation")
    def post(self, ID=None):
        models = PersonGroupRelationModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()