from base_resource import BaseResource
from shift_model import ShiftModel
# from werkzeug.datastructures import FileStorage
import os, werkzeug, base64, pandas as pd

# ========== 新增班別記錄 ==========
class ShiftInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertShift")
        self.parser.add_argument('name', required=True, help="班別，上限20字")
        self.parser.add_argument('start', required=True, help="班別開始時間，上限20字")
        self.parser.add_argument('end', required=True, help="班別結束時間，上限20字")
        self.parser.add_argument('note', help="班別備註")
    def post(self):
        args = self.parser.parse_args()
        model = ShiftModel.FromDBByName(args['name'], self.log.SetMessage)
        if not model.isExist:
            model.SetName(args['name'])
            model.SetStart(args['start'])
            model.SetEnd(args['end'])
            model.SetNote(args['note'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "Shift：{0} inserted".format(args['name'])
            else:
                self.message = "Shift：{0} insert failed".format(args['name'])
        else:
            self.message = "Shift：{0} is exist in database".format(args['name'])
        return self.GetResponse()

# ========== 更新班別紀錄 ==========
class ShiftUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateShift")
        self.parser.add_argument('no', required=True, help="班別編號")
        self.parser.add_argument('name', required=True, help="班別，上限20字")
        self.parser.add_argument('start', required=True, help="班別開始時間，上限20字")
        self.parser.add_argument('end', required=True, help="班別結束時間，上限20字")
        self.parser.add_argument('note', help="班別備註")
    def post(self):
        args = self.parser.parse_args()
        model = ShiftModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetName(args['name'])
            model.SetStart(args['start'])
            model.SetEnd(args['end'])
            model.SetNote(args['note'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeName():
                    self.message.append(
                        "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
                    )
                if model.HasChangeStart():
                    self.message.append(
                        "Start: {0} -> {1}".format(model.GetOldStart(), model.GetStart())
                    )
                if model.HasChangeEnd():
                    self.message.append(
                        "End: {0} -> {1}".format(model.GetOldEnd(), model.GetEnd())
                    )
                if model.HasChangeNote():
                    self.message.append(
                        "Note: {0} -> {1}".format(model.GetOldNote(), model.GetNote())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Shift：{0} update failed".format(args['name'])
        else:
            self.message = "Shift：{0} isn't exist in database".format(args['name'])
        return self.GetResponse()
# ========== 刪除班別紀錄 ==========
class ShiftDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteShift")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = ShiftModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "Shift：{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "Shift：{0} delete failed".format(args['no'])
        else:
            self.message = "Shift：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有班別紀錄 ==========
class ShiftSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectShift")
    def post(self, ID=None):
        models = ShiftModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    