from models import FaceModel, ImageModel, PunchModel
from flask import render_template, request
from flask.views import View
import os

class HomeView(View):
    def dispatch_request(self):
        return render_template("home.html")
class AboutView(View):
    def dispatch_request(self):
        return render_template("about.html")
class InfluxView(View):
    def dispatch_request(self):
        index = request.args['index'] if 'index' in request.args else 0
        image = ImageModel()
        data, page = image.toDict(20, int(index))
        return render_template("influx.html", data=data, page=page)
class ModifyView(View):
    def dispatch_request(self):
        image = request.args['image']
        record = FaceModel.SelectByImage(image).toDict()
        data = []
        data.append(record[0][1])                                  # 人員 ID
        data.append(record[0][2])                                  # 人員名稱
        data.append(record[0][3])                                  # 辨識影像名稱
        data.append(os.path.join('static', 'faces', record[0][3])) # 辨識影像路徑
        return render_template("modify.html", data=data)
class PunchView(View):
    def dispatch_request(self):
        punch = PunchModel()
        return render_template("punch.html", data=punch.toDict())