@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>

{{--    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">--}}
    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
{{--    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>--}}
    <script src="/js/bootstrap-toggle.min.js"></script>

@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '12'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{ csrf_field() }}
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    <div class="row align-items-center" style="height: 70px;">
                        {{--搜尋設備--}}
                        <div class="col-8">
                            <form action="{{ route("select_device") }}">
                                <div class="input-group">
                                    <Select name=set required data-validation-required-message="選擇搜尋的欄位" class="custom-select" id="set">
                                        <Option value="">選擇搜尋的欄位</Option>
                                        <Option value="ID">設備ID</Option>
                                        <Option value="Location">設備位置</Option>
                                    </Select>
                                    <input  type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="value" placeholder="輸入搜尋的值">
                                    <button type="submit" class="btn btn-primary ">搜尋設備</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                        <div class="col-2">
                            <p class="text-right ">共{{$count}}個設備</p>
                        </div>
                    </div>
                    {{--呈現設備--}}
                    <table border="3" class="table table-hover" style="text-align:center;">
                        <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>location</th>
                            <th>host</th>
                            <th>port</th>
                            <th>type</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($devices as $device)
                            <tr>
                                <th>{{ $device["id"] }}</th>
                                <th>{{ $device["location"] }}</th>
                                <th>{{$device["host"]}}</th>
                                <th>{{$device["port"]}}</th>
                                @foreach($types as $type)
                                    @if($type["id"]==$device["type"])
                                        <th>{{$type["name"]}}</th>
                                    @endif
                                @endforeach
                                <th>
                                    <button style="width: 70px;" class="btn btn-success"  data-toggle="modal" data-target="#updateModalCenter" onclick="data('{{ $device["id"] }}','{{ $device["location"] }}','{{$device["host"]}}','{{$device["port"]}}','{{$device["type"]}}')"><strong>修改</strong></button>&nbsp&nbsp&nbsp
                                    <button style="width: 70px;" class="btn btn-danger" onclick="javascript:location.href='{{ Route("delete_device",["id"=>$device["id"]]) }}'"><strong>刪除</strong></button>
                                </th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        {{--彈窗區--}}
        {{--修改設備類型彈跳視窗--}}
        <div class="modal fade" id="updateModalCenter" tabindex="-1" role="dialog" aria-labelledby="updateModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">修改設備</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route("update_device") }}" method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="modal-body">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroup-sizing-default">設備ID</span>
                                    </div>
                                    <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="id" placeholder="ID" id="update_id">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroup-sizing-default">設備location</span>
                                    </div>
                                    <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="location" placeholder="Location" id="update_location">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroup-sizing-default">設備host</span>
                                    </div>
                                    <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="host" placeholder="Host" id="update_host">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroup-sizing-default">設備port</span>
                                    </div>
                                    <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="port" placeholder="Port" id="update_post">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroup-sizing-default">設備type</span>
                                    </div>
                                    <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="type" placeholder="Type" id="update_type">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                            <button type="submit" class="btn btn-primary" >修改</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        {{--方法區--}}
        <script>
            //修改資料帶入
            function data($id,$location,$host,$post,$type) {
                document.getElementById("update_id").value=$id;
                document.getElementById("update_location").value=$location;
                document.getElementById("update_host").value=$host;
                document.getElementById("update_post").value=$post;
                document.getElementById("update_type").value=$type;
            }
        </script>
        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif

@endsection
