@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>

    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="/js/bootstrap-toggle.min.js"></script>

@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '15'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row align-items-center" style="height: 70px;">
                        {{--搜尋設備類型--}}
                        <div class="col-8">
                            <form action="{{ route("select_relation") }}">
                                <div class="input-group">
                                    <Select name=set required data-validation-required-message="選擇搜尋的欄位" class="custom-select " id="group_id">
                                        <Option value="">選擇搜尋的欄位</Option>
                                        <Option value="DeviceID">設備ID</Option>
                                        <Option value="DeviceGroupID">群組名稱</Option>
                                    </Select>
                                    <input  type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="value" placeholder="輸入搜尋的值">
                                    <button type="submit" class="btn btn-primary ">搜尋設備與群組關係</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                        {{--新增設備類型--}}
                        <div class="col-2">
                            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#exampleModalCenter">
                                新增設備與群組關係
                            </button>
                        </div>
                    </div>
                    {{--呈現設備群組關係--}}
                    <table border="3" class="table table-hover" style="text-align:center;">
                        <thead class="thead-dark">
                        <tr>
                            <th>群組名稱</th>
                            <th>設備</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($relations as $relation)
                            <tr>
                                @foreach($device_groups as $device_group)
                                    @if($relation["device_group_id"]==$device_group["id"])
                                        <th>{{ $device_group["name"] }}</th>
                                    @endif
                                @endforeach
                                <th>{{ $relation["device_id"] }}</th>
                                <th><button style="width: 70px;" class="btn btn-danger" onclick="javascript:location.href='{{ Route("delete_relation",["device_id"=>$relation["device_id"],"device_group_id"=>$relation["device_group_id"]]) }}'" ><strong>刪除</strong></button></th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    @if(isset($count))
                        <p class="text-right ">共{{$count}}個設備</p>
                    @endif
                </div>

            </div>

        </div>
        {{--彈窗區--}}
        {{--新增群組彈跳視窗--}}
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">新增設備與群組關係</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route("insert_relation") }}" method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="modal-body">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <label class="input-group-text" for="inputGroupSelect01">選擇設備ID</label>
                                    </div>
                                    <Select name=device_id style="width: 200px;" required data-validation-required-message="設備ID" class="custom-select" id="device_id">
                                        @foreach($devices as $device)
                                                <Option value="{{ $device["id"] }}">{{ $device["id"] }}</Option>
                                        @endforeach
                                    </Select>
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <label class="input-group-text" for="inputGroupSelect01">選擇群組</label>
                                    </div>
                                    <Select name=group_id style="width: 200px;" required data-validation-required-message="群組ID" class="custom-select" id="group_id">
                                        @foreach($device_groups as $device_group)
                                            <Option value="{{ $device_group["id"] }}">{{ $device_group["name"] }}</Option>
                                        @endforeach
                                    </Select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                            <button type="submit" class="btn btn-primary">新增</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        {{--方法區--}}
        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif
@endsection
