@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>

    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="/js/bootstrap-toggle.min.js"></script>

    {{--引入 datetimepicker 相關套件--}}
    <script type="text/javascript" src="/bower_components/moment/moment.js"></script>
    <script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
    <script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
    <link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
    <link href="/css/font-awesome.min.css" rel="stylesheet">

@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '16'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row align-items-center" style="height: 70px;">
                        <div class="col-3">
                            
                        </div>
                        <div class="col-6">
                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">伺服器時間</div>
                                </div>
                                <input id='server_dt' style="text-align: center" name="server_dt" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <form method="POST" action="{{ Route("set_device_time")}}" nonvalidate>
                        {{ csrf_field() }}
                        <div class="row align-items-center" style="height: 70px;">
                            <div class="col-3">
                                
                            </div>
                            <div class="col-6">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">本地時間</div>
                                    </div>
                                    <input id='user_dt' style="text-align: center" name="user_dt" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <button type="submit" class="btn btn-dark">更新時間</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                            </div>
                        </div>
                    </form>

                    </div>
                </div>

            </div>
        </div>
        {{--方法區--}}
        <script>
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ $server_time }}")
            });
        });
        $(document).ready(function() {
            // Called the function in each second
            var server_dt_interval = setInterval(function() {
                serverdt = document.getElementById("server_dt");
                times= new Date(serverdt.value).getTime()+1000;
                dt = new Date(times);
                month = dt.getMonth()+1;
                day = dt.getDate();
                hours = dt.getHours();
                mins = dt.getMinutes();
                ss = dt.getSeconds();
                if(month<10){
                    month = "0"+month;
                    }
                if(day<10){
                    day = "0"+day;
                    }
                if(hours<10){
                    hours = "0"+hours;
                    }
                if(mins<10){
                    mins = "0"+mins;
                    }
                if(ss<10){
                    ss = "0"+ss;
                    }
                serverdt.value = dt.getFullYear()+"-"+month+"-"+day+" "+hours+":"+mins+":"+ss;
            }, 1000); // Run for each second
            
        });
        /*
        var user_dt_interval = setInterval(function() {
            userdt = document.getElementById("user_dt");
            dt= new Date();
            month = dt.getMonth()+1;
            day = dt.getDate();
            hours = dt.getHours();
            mins = dt.getMinutes();
            ss = dt.getSeconds();
            if(month<10){
                month = "0"+month;
                }
            if(day<10){
                day = "0"+day;
                }
            if(hours<10){
                hours = "0"+hours;
                }
            if(mins<10){
                mins = "0"+mins;
                }
            if(ss<10){
                ss = "0"+ss;
                }
            userdt.value = dt.getFullYear()+"-"+month+"-"+day+" "+hours+":"+mins+":"+ss;
        }, 1000); // Run for each second
        */
        </script>

        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif
@endsection
