@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 60vh !important;
        }
        .table-condensed{
            font-size: 15px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '10'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <form class="row" id="attendance_setting_from" method="post" action="{{ Route('attendance') }}" style="height: 20vh">
                        {{ csrf_field() }}
                        <div class="col-4">
                            <div class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">上班時間</div>
                                </div>
{{--                                <input id='time_in' style="text-align: center" name="time_in" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required value="{{ $export_arg['In'] }}"/>--}}
                                <input id='time_in' style="text-align: center" name="time_in" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required value="{{ old("time_in","08:30") }}"/>
                                <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="input-group date" id="datetimepicker5" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">下班時間</div>
                                </div>
{{--                                <input id='time_out' style="text-align: center" name="time_out" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker5" required value="{{ $export_arg['Out'] }}" />--}}
                                <input id='time_out' style="text-align: center" name="time_out" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker5" required value="{{ old("time_out","17:30") }}" />
                                <div class="input-group-append" data-target="#datetimepicker5" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">午休分鐘</div>
                                </div>
                                <input id='time_break' style="text-align: center" name="time_break" type="number" min="0" class="form-control datetimepicker-input" data-target="#datetimepicker6" required value="{{ $export_arg['LunchBreak'] }}" onchange="input_value_binding('time_break','export_time_break')"/>
                            </div>
                        </div>
                        <div class="col-1">
                            @if($level=="3" or $level=="4")
                                <button name="export" type="button" class="btn btn-dark mb-2" onclick="export_day()">匯出</button>
                            @endif
                        </div>
                        {{--datetime 起始時間選擇--}}
                        <div class="col-4">
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">起始時間</div>
                                </div>
                                <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        {{--datetime 結束時間選擇--}}
                        <div class="col-4">
                            <div  class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">結束時間</div>
                                </div>
                                <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                    <option value="default" selected>請選擇類別</option>
                                    <option value="all">全部</option>
                                    <option value="late">遲到</option>
                                    <option value="early">早退</option>
                                    <option value="over">加班</option>
                                    <option value="noarrived">未出席</option>
                                </select>
                                <input name="search_text" type="text" class="form-control" placeholder="" value="{{ old("search_text") }}">
                            </div>
                        </div>
                        <input type="hidden" id="groupid" name="groupid" value="{{ old('groupid') }}">
                        <div class="col-1">
                            <button name="select" type="submit" class="btn btn-dark mb-2">查詢</button>
                        </div>
                    </form>
                    {{--表格呈現-呈現出勤資訊--}}
                    <table class="table table-striped table-bordered table-hover table-condensed" id="tableL01"  style="height: 60vh"></table>
                    {{--底端部分(無資料)--}}
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        @if($level=="3" or $level=="4")
                            <div class="col-6">
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;"  data-toggle="modal" data-target="#InsertFiles">匯入假期資料</button>
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;"  data-toggle="modal" onclick="location.href='{{ route("excel_insert_holiday_example") }}'">下載匯入範例</button>
                            </div>

                            <div class="col-6">
                                <form class="row" id="form_attendance_download" method="POST" action="{{ Route("attendance_download") }}">
                                    {{ csrf_field() }}
                                    {{-- 隱藏欄位 --}}
                                    <input type="hidden" name="export_time_in" id="export_time_in" value="{{ $export_arg['In'] }}">
                                    <input type="hidden" name="export_time_out" id="export_time_out" value="{{ $export_arg['Out'] }}">
                                    <input type="hidden" name="export_time_break" id="export_time_break" value="{{ $export_arg['LunchBreak'] }}">

                                    <div class="input-group date" id="datetimepicker3" data-target-input="nearest" >
                                        <select name="choses_group" id="choses_group" class="custom-select">
                                            <option value="">請選擇群組</option>
                                            @foreach($person_groups as $person_group)
                                                @if(old('groupid') == $person_group["id"])
                                                <option selected="selected" value="{{$person_group["id"]}}">{{$person_group["name"]}}</option>
                                                @else
                                                <option value="{{$person_group["id"]}}">{{$person_group["name"]}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">匯出月份</div>
                                        </div>
                                        <input id='export_date' style="text-align: center" name="export_date" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                        <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <div class="input-group-append">
                                            <button class="btn btn-dark" type="submit">匯出</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--匯入檔案--}}
    <div class="modal fade" id="InsertFiles" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">匯入假期資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("excel_insert_holiday") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-8">
                            <input type="file" id="file" name="excel" accept=".xls,.xlsx">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{--方法區--}}
    <script>
        //匯出日報表
        function export_day()
        {
            document.getElementById("attendance_setting_from").action="{{ Route('attendance_download_day') }}";
            document.getElementById("attendance_setting_from").submit();
            document.getElementById("attendance_setting_from").action="{{ Route('attendance') }}";
        }
    </script>
    <script>
        //選擇群組
        $('#choses_group').on('change',function () {
            document.getElementById("groupid").value=document.getElementById("choses_group").value ;
        });
    </script>
    <script>
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
    </script>
    {{--  匯出按鈕--}}
    <script>
        function attendance_download(){
            let form = document.getElementById("form_attendance_download");
            document.getElementById("export_time_break").value=document.getElementById("time_break").value;
            document.getElementById("export_time_in").value=document.getElementById("time_in").value;
            document.getElementById("export_time_out").value=document.getElementById("time_out").value;
            let formData = new FormData(form);
            $.ajax({
                url:"{{ Route("attendance_download") }}",
                type : "POST",
                data : formData,
                contentType: false,
                cache: false,
                processData: false,
                success : function(data)
                {
                    console.log(data);
                },error: function(data)
                {
                    console.log('無法送出');
                }
            })
        }
        // input雙向綁定
        function input_value_binding(a,b) {
            document.getElementById(b).value=document.getElementById(a).value;
        }
        // datetimpicker value and hidden input 雙向綁定
        $("#datetimepicker4").on("change.datetimepicker", function (e) {
            if (e.oldDate !== e.date) {
                document.getElementById("export_time_in").value=document.getElementById("time_in").value;
            }
        })
        $("#datetimepicker5").on("change.datetimepicker", function (e) {
            if (e.oldDate !== e.date) {
                document.getElementById("export_time_out").value=document.getElementById("time_out").value;
            }
        })
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--表格設定(boostrap-tabel)--}}
       <script>
           //載入資料
           @php
               if (isset($rowdata)){
                   echo "var jdata=".json_encode($rowdata).';';
               }else{
                   echo "var jdata=[];";
               }
           @endphp
           //動態載入表格之前，先銷燬表格
        $('#tableL01').bootstrapTable('destroy');
           //設定欄位標題
        var tableColumns = [
            {field: 'day', title: '日期', sortable: true},
            {field: 'img', title: '人臉庫圖片', sortable: false},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'id', title: '編號', sortable: true},
            {field: 'stime', title: '上班', sortable: true},
            {field: 'etime', title: '下班', sortable: true},
            {field: 'late', title: '遲到', sortable: true},
            {field: 'early', title: '早退', sortable: true},
            {field: 'over', title: '加班', sortable: true},
            {field: 'remarks', title: '備註', sortable: false},
        ];
           //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            pageSize: 5, //每頁3條
            pageNumber: 1,  //第1頁
            pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
    </script>
    {{--日期選擇設定--}}
    <!-- 上班時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date().setHours(23,59,59),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y-m-d")." 00:00:00") }}"), // 初始值
            });
        });
    </script>
    <!-- 下班時間 (datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date().setHours(23,59,59),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{old('end_time',date("Y-m-d")." 23:59:59") }}") // 初始值
            });
        });
    </script>
    <!-- 選擇月份 (datetimepicker3物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- 起始時間 (datetimepicker4物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker4').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'HH:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- 結束時間 (datetimepicker5物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker5').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'HH:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
@endsection
