@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        .seeline{
            border: #000000 1px solid;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')
    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '5'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-5" style="padding-right: 0px;">
                            <form method="POST" action="{{ route('personG_search') }}">
                                {{ csrf_field() }}
                                <div class="input-group">
                                    <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                        <option value="default" selected>請選擇類別</option>
                                        <option value="1">人員編號</option>
                                        <option value="2">人員名稱</option>
                                    </select>
                                    <input name="search_text" type="text" class="form-control" placeholder="欲搜尋內容" >
                                    <div class="input-group-append">
                                        <button class="btn btn-dark" type="submit">搜尋</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-5" style="text-align: right">
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="post_delete_personG()">移出群組</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertMemberModalCenter">新增人員群組</button>
                        </div>
                        <div class="col-2" style="text-align: left">
                            <form method="GET" action="{{ route('Group_index') }}">
                                {{ csrf_field() }}
                                <button class="btn btn-dark" type="submit" >回到上一頁</button>
                            </form>
                        </div>
                    </div>
                    {{--表格呈現-群組內人員列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL02"  style="height: 75vh"></table>
                </div>
            </div>
        </div>
    </div>
{{--彈窗區--}}
{{-- 新增群組人員彈出視窗 --}}
<div class="modal fade" id="InsertMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="height: 60vh">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">新增人員群組</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            {{ csrf_field() }}
            <div class="modal-body row">
                <div class="col-sm-12" style="height: 40vh; overflow: auto">
                    <table class="table table-striped table-bordered table-hover" style="height: 75vh" id="tableL01"></table>
                </div>
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-primary" onclick="post_insert_personG()">提交</button>
            </div>
        </div>
    </div>
</div>
    {{--方法區--}}
    <script>
        {{--    取得已選取目標--}}
        function insertIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.id
            })
        }
        function getIdSelections() {
            return $.map($('#tableL02').bootstrapTable('getSelections'), function (row) {
                return row.id
            })
        }
        function  getNameSelections() {
            return $.map($('#tableL02').bootstrapTable('getSelections'), function (row) {
                return row.name
            })
        }
        {{--移除群組--}}
        function post_delete_personG() {
            let idselections=getIdSelections();
            let nameselections=getNameSelections();
            if(confirm("是否刪除"+nameselections)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("delete_personG") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var nameselectionsField = document.createElement("input");
                nameselectionsField.setAttribute("type", "hidden");
                nameselectionsField.setAttribute("name", "selectedName");
                nameselectionsField.setAttribute("value",nameselections);
                form.appendChild(nameselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }

        function post_insert_personG() {
            let idselections=insertIdSelections();
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("insert_personG") }}");
            var gidselectionsField = document.createElement("input");
            gidselectionsField.setAttribute("type", "hidden");
            gidselectionsField.setAttribute("name", "selectedpId");
            gidselectionsField.setAttribute("value",idselections);
            form.appendChild(gidselectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }

    </script>
{{--跳出錯誤訊息    --}}
@if(isset($error_msg))
    <script>
        alert('{{ $error_msg }}');
    </script>
@endif

{{--表格設定(boostrap-tabel)--}}
{{--未在群組內的人員--}}
<script>
    // 載入資料
    @php
        if(isset($rowdata)){
            echo "var jdata=".json_encode($rowdata).";";
        }else{
            echo "var jadata=[];";
        }
    @endphp
    //動態載入表格之前，先銷燬表格
    $('#tableL01').bootstrapTable('destroy');
    //設定欄位標題
    var tableColumns = [
        {field: 'state', checkbox: true,},
        {field: 'id', title: '人員編號', sortable: true},
        {field: 'name', title: '人員名稱', sortable: true},
    ];
    //設定表格
    $('#tableL01').bootstrapTable({//表格初始化
        locale:"zh-TW",// 地區語系轉換
        columns: tableColumns,  //表頭
        data:jdata, //通過ajax返回的資料
        width:0,
        //height:10,
        method: 'get',
        // pageSize: 5, //每頁3條
        // pageNumber: 1,  //第1頁
        // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
        cache: false,   //不快取
        striped: true,
        pagination: false,
        sidePagination: 'client',
        search: true,
        showRefresh: false,
        showExport: false,
        showFooter: false,
        exportTypes: ['csv', 'txt', 'xml','excel'],
        clickToSelect: true,
        sortName:'day', // 預設排序
    });
</script>
{{--群組內的人員--}}
<script>
    // 載入資料
    @php
        if(isset($rowdata2)){
            echo "var jdata=".json_encode($rowdata2).";";
        }else{
            echo "var jadata=[];";
        }
    @endphp
    //動態載入表格之前，先銷毀表格
    $('#tableL02').bootstrapTable('destroy');
    //設定欄位標題
    var tableColumns = [
        {field: 'state', checkbox: true,},
        {field: 'img', title: '人員圖片', sortable: true},
        {field: 'name', title: '人員編號', sortable: true},
        {field: 'personname', title: '人員名稱', sortable: true},
    ];
    //設定表格
    $('#tableL02').bootstrapTable({//表格初始化
        locale:"zh-TW",// 地區語系轉換
        columns: tableColumns,  //表頭
        data:jdata, //通過ajax返回的資料
        width:0,
        height:1,
        method: 'get',
         pageSize: 5, //每頁5條
        // pageNumber: 1,  //第1頁
        // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
        cache: false,   //不快取
        striped: true,
        pagination: false,
        sidePagination: 'client',
        search: false,
        showRefresh: false,
        showExport: false,
        showFooter: false,
        exportTypes: ['csv', 'txt', 'xml','excel'],
        clickToSelect: true,
        sortName:'day', // 預設排序
    });
</script>
@endsection
